function [ppi dppi dt] = clusterfunction(x,y,w,iGmax,t,func,beta)
% CLUSTERFUNCTION computes value of PPIndex for given vector X(I).
%
%    PPI = CLUSTERFUNCTION(X,Y,W,t) value of PPI for in respect to W and T,
%            where T is a center of cluster associated with class Y(I)
%
%    PPI = CLUSTERFUNCTION(X,Y,W,I,T,FUNC) 
%    PPI = CLUSTERFUNCTION(X,Y,W,I,T,FUNC,BETA) 
%
%    [PPI DPPI] = CLUSTERFUNCTION(...) 
%
%    [PPI DPPI DCENTER] = CLUSTERFUNCTION(...) 
%%
if ( nargin < 5 )
    error('Za malo argumentow');
end
if nargin < 7
  %  disp('BETA not set - using default value BETA = 10');
    beta = 2;
end

if  nargin < 6
    func=@(x)f_x4(x,beta);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end
if nargin < 4 || isempty(iGmax)
    [ppi projection G] = ppifunction(x,y,w,func,beta);
    [Gmax iGmax]=max(G);
end

[vectorsCount featuresCount] = size(x);

labelIndex = (y == y(iGmax));
labelsCount=sum(labelIndex);

Ap = labelsCount;
An = (vectorsCount-labelsCount);

projection = x*w';
labelIndex = (y == y(iGmax));
%labelsCount=sum(labelIndex);

if nargout > 1
    dppi =zeros(1,featuresCount);
end

[f df] = func(projection - t*w');
plus = sum(labelIndex.*f)./Ap;
minus = sum((~labelIndex).*f)./An;
ppi = plus - minus;

if nargout > 1
    xd = x - ones(vectorsCount,1)*t;
 
    dplus = ((labelIndex.*df)'*xd)./Ap;
    dminus = (((~labelIndex).*df)' * xd)./An;
    dppi = dplus - dminus;
    dtplus = - ((labelIndex.*df)'*(ones(vectorsCount,1)*w))./Ap;
    dtminus = - (((~labelIndex).*df)' * (ones(vectorsCount,1)*w))./An;

    dt = dtplus - dtminus;
end
