function [y dy]=f_triangular(x,a,c)
%
% Y=F_TRIANGULAR(X)
%
%    returns value of triangulat  function for given X
% 
% Y=F_TRIANGULAR(X,A,C)
%
%    return value of triangular function with:
%    A width of function (default A=1)
%    C center of function (default C=0)
%
if nargin < 3
    c = 0;
end;
if nargin < 2
	a = 1;
end

yy = x-c;
y = zeros(size(x));

idx1= (yy >= -a) & (yy < 0);
idx2 = (yy >= 0) & (yy <= a);

y(idx1) = yy(idx1)./a + 1;
y(idx2) = 1- yy(idx2)./a; 

if nargout > 1
    dy = zeros(size(x));
    dy((yy >= -a) & (yy < 0))= 1/a;
    dy((yy >= 0) & (yy <= a)) = -1/a;
end
