function d=plotKsep(in,out,w,boundries,n);
% graficzna reprezentacja klastrow K-separowlnosci na prostej dla
% danego kierunku i ewentulanie dla danych granic boundries

if nargin < 3 
    disp('blad narhin < 3');
    return;
end

yp    = in*w';

d=[yp out];

id1=find(out == 1);
id0=find(out == 0);

y0=zeros(1,size(id0,1));
y1=zeros(1,size(id1,1));
minyp=min(yp);
maxyp=max(yp);

clf;
plot(yp(id0),y0,'r.','MarkerSize',10);
hold on;
plot(yp(id1),y1,'g.','MarkerSize',10);
ymin =-0.5;
ymax = 0.5;

axis([minyp-0.2 maxyp+0.2 ymin ymax]);

text(minyp,ymin+0.1,strcat('w = [  ',num2str(w),' ]'));

if nargin > 3
   line([boundries(:) boundries(:)]',[-.2 .2]','Color',[0,0,0]); 
end
if nargin > 4
    c = [ minyp; boundries; maxyp]; 
    centers = (c(1:end-1)+c(2:end))./2.0;
    ytext=ones(size(centers,1),1).*0.3;
    text(centers,ytext,num2str(n(:)));
end

