function [ppi dppi projection G] = ppigmaxfunction2(x,y,w,iGmax,func,beta)
% PPIGMAXFUNCTION computes value of PPIndex for given vector X(I).
%
%    PPI = PPIGMAXFUNCTION(X,Y,W,I) computes value of PPIndex for given dataset
%    X, label table Y and direction W (weights).
%
%    PPI = PPIGMAXFUNCTION(X,Y,W,I,FUNC) computes value of PPIndex with given function FUNC (function handle, default FUNC=@F_X4).
%    PPI = PPIGMAXFUNCTION(X,Y,W,FUNC,BETA) parameter BETA defines width of
%    function FUNC (BETA it must be secound argument of FUNC)
%
%    [PPI DPPI] = PPIGMAXFUNCTION(...) returns value of gradient df/dx, the
%    function FUNC must return it's gradient value as a secound output.
%
%    [PPI DPPI PROJ] = PPIGMAXFUNCTION(...) returns value of X*W', for some
%    reasons may be usefull.
%
%   [PPI DPPI PROJ G] = PPIGMAXFUNCTION(...) here G = PPI, needed for
%   compatibilyty with some instructions in PPOPTIMIZE script.
%
%  Note that: PPIFUNCTION give an average value of PPIGMAXFUNCTION over all
%  vestors X.


%Funkcja oblicza wartosc indexsu ppi, dla danych wektorow X oraz etykiet
% klas Y oraz podanego kierunku W i funkcji FUNC.
% Wartosci zwracane: 
%   PPI  - wartosc indexu
%   DPPI - pochodna funkcji 
%   PROJ - rzyt x*w' - mozna wykozystac w dalszych obliczeniach aby nie
%           powtarzac tej operacji wielokratnie
%   G    - tablica wartosci dla kazdego z wektorow  PPI = 1/A sum G(x)
%%
if ( nargin < 4 )
    error('Za malo argumentow');
end
if nargin < 6
  %  disp('BETA not set - using default value BETA = 10');
    beta = 2;
end

if  nargin < 5
    func=@(x)f_x4(x,beta);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end
if nargin < 4 || isempty(iGmax)
    [ppi projection G] = ppifunction(x,y,w,func,beta);
    [Gmax iGmax]=max(G);
end

[vectorsCount featuresCount] = size(x);

projection = x*w';
labelIndex = (y == y(iGmax));
labelsCount=sum(labelIndex);

if nargout > 1
    dppi =zeros(1,featuresCount);
end

[f df] = func(projection - projection(iGmax));
plus = sum(labelIndex.*f)./labelsCount;
minus = sum((~labelIndex).*f)./(vectorsCount-labelsCount);
ppi = plus - minus;

if nargout > 1
    xd = x - ones(vectorsCount,1)*x(iGmax,:) ;
    dplus = ((labelIndex.*df)'*xd)./labelsCount;
    dminus = (((~labelIndex).*df)' * xd)./(vectorsCount-labelsCount);
    dppi = dplus - dminus;
end
G = ppi;

%% OLD VERSION
% [vx fx]=size(x);
%
% ppiplus = 0;
% ppiminus = 0;
% A=0;
% B=0;
% 
% projection = x*w';
% G = zeros(1,vx);
% 
% for i=1:vx
%     j=iGmax;
%     diff = projection(j,:)-projection(i,:);
% %    xd = (x(j,:)-x(i,:));
%     dpii = func(diff,beta);
% %    dfuncvalue = dfunc(diff,beta).*xd; 
%     if y(i) == y(j)
%         G(i) = G(i) + dpii;
%         G(j) = G(j) + dpii;
% %  					ppiplus = ppiplus + dpii;
% %        ppiplus2 = ppiplus2 + dfuncvalue;
%         A=A+1;
%     else
% %  					ppiminus = ppiminus + dpii;
%         G(i) = G(i) - dpii;
%         G(j) = G(j) - dpii;
% %  					
% %        ppiminus2 = ppiminus2 + dfuncvalue;
%         B=B+1;
%     end
% 
% end
% ppi = sum(G)/A;
