function ci=classstat(y)
% returns structure CI whit basic statisctics of caterogical feature Y (eg.
% class labels)
%
% ci.classCount - number of categories
% ci.labelIndex - binary matrix, category maping, 1-per-class
% ci.labels - labels values
% ci.labelsCount - number of values per category (label)

[labels a index] = unique(y);

ci.classCount = size(labels,1);
ci.labelIndex = zeros(length(y),ci.classCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

for i=1:ci.classCount
    ci.labelIndex(:,i) = (index == i);
end

ci.labels=labels';
ci.labelsCount=sum(ci.labelIndex);
