function [y dy]=f_gauss(x,s,t)
%   
%   Y = F_GAUSS(X,S,T)
%
%	compute value of the Gauss function y(x)=exp[-(x-t)^2/2*S]
%	S  : width (default 1)
%	T  : center (default 0)
%
% [Y DY]=F_GAUSS(X,S,T)
%
%    returns DY - value of gradient df/dx
%
% Note that   F_GAUSS(X,S,T) = F_GAUSS( (X-T).^2./(2*S) )

if nargin < 3
     t = zeros(size(x));
end;
if nargin < 2
       s = 1;
end;

x1=(x-t); 
x2=-x1.*x1;
m=0.5*x2./s;
y=exp(m);

if nargout > 1
    dy=-(x1.*y)./s;
end
