function [err node ic cl] = clusteroptimize_mse(x,y,w,varargin)
%    OPTIONS for MSE 
%            'labels'  
%            'tresholds'
%             Note: it is important to  use correct 'function'. 


if nargin < 3; error('Error while parser options.'); end;
[qpc_parameters unmached] = qpc_config(varargin{:});
parameters = clusteroptimize_mse_config(unmached);

% is_mse = strcmp(parameters.ClusterMethod,'mse') == 1;
% is_qpc = ~is_mse;

% if parameters.plr == 0 
%     parameters.plr = parameters.learningRate;
% end
% qpc_parameters.QPCMethod = 'proto';


% beta        = parameters.beta;
lrate       = qpc_parameters.learningRate;	% learning rate (step of gradnient descent)
% eps         = parameters.eps;	% 
nmax        = qpc_parameters.maxIterations;     % nax. number of iterations
% iplot       = 0;
% %lastppi     = -1;
% % ffplot      = 0;
% plotall = 0;
% ninit       = parameters.initiations;
% %ww          = parameters.initWeights;
% dataname    = parameters.dataName;
% avgtest     = parameters.checkPeriod;
stopcriterium = qpc_parameters.stopCriterium;
% igmax       = parameters.indGmax;
% wort        = parameters.ortoWeights;
% lambda      = parameters.lambda;
% orto        = ~isempty(wort);
% funcname    = parameters.function;
% %wo          = 0;
% %saveall     = 0;
% %savelast    = 0;
% %savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));
% procedure   = '';
% display     = 0;
% ksi = 0.5;  % procent poprawnych wektorow w klastrze
% 
% %bestw = [];
% %bestppi = [];
% %bestinit = 0;
% %bestn = 0;
% %bestigmax = -1;
% 
% %if ~isempty(parameters.savedir)
% %    savedir = parameters.savedir;
% %end

% switch qpc_parameters.display
%     case 'all'
%         display = 2;
%     case 'short'
%         display = 1;
%     case 'none'
%         display = 0;
% end
% switch qpc_parameters.plot
%     case 'all'
%         plotall = 1;
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


avgerr = Inf;
avgtest = qpc_parameters.checkPeriod;
lastavgerr = Inf;
%be = 1; % slope
vectorsCount = size(x,1);

if isempty(parameters.label); error('Labels must be specified for MSE learning'); end
if isempty(parameters.tresholds); error('Tresholds must be specified for MSE learning'); end
label = parameters.label;
a = parameters.tresholds(1);
is_window = length(parameters.tresholds) == 2;
if is_window; b = parameters.tresholds(2); else b = a; end

n  = 0;
% ppitable=zeros(1,nmax);
errtable = zeros(1,nmax);
labelsIndex = (y == label);
positive = sum(labelsIndex);
%labelsPerClassCount = sum(labelsIndex);

node.n = 1;
node.w=w;
node.label = label;
node.a=a;
node.b=b;
% f{1}=parameters.ClusterFunction;
% node.func=f;
node.np = 0;
node.nn = 0;
node.npall = positive;
node.all = vectorsCount;
node.treshold = 0.5;
node.error = +Inf;
node.slope = 1;
slr = 1;
alr = -1;
blr = -1;
llr = 1;
llw = 1;
stopcriterium = -1;

while ( 1 )
    if (mod(n,avgtest) == 0 && n > 0)
        lastavgerr = avgerr;
        avgerr = mean(errtable(n-avgtest+1:n));
        node.slope = node.slope*slr;
        lrate = lrate*llr;
    end;

  %  node.w=node.w/norm(node.w);
    
    projection = x*node.w';

    if is_window
        clind = (projection < b) .* (projection > a);
    else
        clind = (projection > a);
    end
    node.nn = sum(clind);
    cl = find(clind);
    ynew =  clind .*labelsIndex;
    ic = find(~ynew);
    node.np = nnz(ynew);


    if is_window
        func=@(x)parameters.ClusterFunction(x,node.a,node.b,node.slope);
    else
        func=@(x)parameters.ClusterFunction(x,node.a,node.slope);
    end

    
    figure(1);
    clf;
    
    bgraph(projection,ynew,'borders',[node.a node.b]);
    figure(2);
    clf;
    ymin=min(projection);
    ymax=max(projection);
    xx=ymin:0.1:ymax;
    plot(xx,func(xx));
    if n > 1
        figure(3);
        clf;
        plot(errtable(1:n));
    end
    [err dw da db]=mse_error(x,ynew,node.w,func,is_window);

    lasterr = err;
    errtable(1,n+1) = err;
    node.error = err;

    %    if iplot == 1 && n > 0
    %         plotppi(ppitable,n,avgtest);
    %         drawnow;
    %    end
    %         if display > 0
    %             fprintf('%3d  %5.3f [%s ] (%5.3f,%5.3f) +%d/%d -%d/%d %4.1f%%  %4.2f b %.2f l %.4f\n',n,ppi,sprintf(' %5.3f',w),a,b,np,positive,nn-np,vectorsCount-positive,100*np/vectorsCount,np/nn,be,lrate);
    %         end
    %         if plotall == 1
    %             str=cell(1,3);
    %             clf;
    %             set(gcf,'Color','w');
    %             if orto == 0
    %                 str{1} = strcat('w = ',sprintf(' %.2f ',w));
    %                 str{2} = strcat('I = ',sprintf(' %.5f ',ppitable(n+1)));
    %                 str{3} = strcat('N = ',sprintf(' %d ',n));
    %  
    %               %  ah = bgraph3(projection,y,'position',[0.05 0.4 0.9 0.50],'function',func,'sigma',0.1);
    %                   ah = bgraph4(projection,y,'position',[0.05 0.4 0.9 0.50],'function',func,'sigma',0.1,'borders',[a b]);
    % 
    %                 axes(ah(1));
    %                 text(0.01,0.95,str,'units','normalized');
    %             else
    %                 str{2} = strcat('\alpha = ',sprintf(' %.4f ',w1));
    %                 str{1} = strcat('I = ',sprintf(' %.4f ',ppitable(n+1)));
    %                 str{3} = strcat('N = ',sprintf(' %d ',n));
    %                 
    %                 scaterplot([projection ortoproj],y);
    %                 
    %                 set(gca,'position',[0.1 0.45 0.85 0.50]);
    %                 xlabel(strcat('w2 = ',sprintf(' %.2f ',w)));
    %                 ylabel(strcat('w1 = ',sprintf(' %.2f ',wort)));
    %                 
    %                 text(0.02,0.85,str,'units','normalized');
    %            end
    %             axes('position',[0.1 0.1 0.85 0.25]);
    %             plotppi(ppitable,n,50);
    %             drawnow();
    %         end;


    if (stopcriterium == 1 && (abs((err - lasterr)/lasterr) < eps) && n > 1 ) 
        break;
    end;
    if (stopcriterium == 2 && abs((avgerr - lastavgerr)/lastavgerr) < eps && n > 1 ) 
        break;
    end;
    if ( n >= nmax ) 
        break;
    end


    node.w = node.w - llw* lrate * dw;
     node.a = node.a + alr * da;
      if is_window
          node.b = node.b - blr * db;
      end
    
    disp(node)
    n = n + 1;
end;

    
    

function plotppi(ppitable,n,scalefactor)
if nargin < 3
    scalefactor = 10;
end
if nargin < 2
    n = length(ppitable);
end
xl = scalefactor.*(fix(n./scalefactor)+1);
cla;
hold on;
xlim([0 xl]);
xlabel('Iterations');
ylabel('PPI value');
plot(0:n,ppitable(1:n+1),'-b','LineWidth',2);
box on;
hold off;

    
function [parameters unmached]=clusteroptimize_mse_config(varargin)

param = inputParser;
param.KeepUnmatched = true;
%param.addOptional('ClusterMethod','mse',@(x)any(strcmpi(x,{'mse','qpc'})));
param.addOptional('ClusterFunction',[]);
param.addOptional('label',[],@(x)isnumeric(x));
param.addOptional('tresholds',[],@(x)isnumeric(x));
param.parse(varargin{:});
parameters = param.Results;
unmatched = param.Unmatched;
unames=fieldnames(unmatched);
clear param;

if nargout  < 2 && size(unames,1) > 0
        error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
end
return;


function [err dw da db]=mse_error(x,y,w,func,is_window)

    proj=x*w';
    if is_window
        [fx dfx da db] = func(proj);
    else
        [fx dfx da] = func(proj);
    end
    dy = fx-y;
    err = mean(dy.*dy);
    xxx = dy.*dfx;
    dw = 2*mean(xxx(:,ones(1,size(x,2))).*x);
    da = 2*mean(xxx.*da);
    if is_window
        db = 2*mean(xxx.*db);
    else
        db = 0;
    end
