function [corrc cid]=corr_feat_sel(x,y,option,val)
% CORR_FEAT_SEL  - computes linear correlation beetwen dataset and labels
% vector. 
%
% CC = CORR_FEAT_SEL(X,Y)  
%          return coefficient vector beetwenn each feature in X and Y
%
% [CC IND] = CORR_FEAT_SEL(X,Y,'features',N)  
%          return coefficient vector CC and indexes IND of first N features with highest CC value
%
% [CC IND] = CORR_FEAT_SEL(X,Y,'correlation',VAL)  
%          return coefficient vector CC and indexes IND of features with CC>=VAL
%
% [CC IND] = CORR_FEAT_SEL(X,Y,'fraction',VAL)  
%          return coefficient vector CC and indexes IND of given fraction
%          of features with highest CC value

fn = size(x,2);
corrc = zeros(1,fn);

for i=1:fn
    s = std(x(:,i));
    if s == 0 
        c = 0;
    else
        a = corrcoef(x(:,i),y);
        c = abs(a(1,2));
    end
    corrc(1,i) = c; 
end

cid = [];
cc = 0;

 
if nargin > 2
    switch lower(option)
        case {'features'}
            csort = sort(corrc,'descend');
            cc = csort(val);
        case {'cc','correlation'}
            if val >= 0 && val <= 1
                cc = val;
            else
                error('Value of correlaction must be in [0,1]\n');
            end
        case 'fraction'
            if val >= 0 && val <= 1
                csort = sort(corrc,'descend');
                cc = csort(round(val*fn));
            else
                error('Value of fraction must be in [0,1]\n');
            end
        otherwise
            error('Unknown option: %s\n',option);
    end
end

cid = find(corrc >= cc);
corrc = corrc(cid);

% fprintf('CC=%f\n',cc);
% nfeat = length(cid);
% fprintf('CC=%f\nN=%d\nfrac=%.2f\n',cc,nfeat,100*(nfeat/fn));


