% policz rozklad k-sep dla danej projekcji W dla N bitow
%Start od W=111..11
%Oblicz Y=W*X/|W|
%Oblicz liczbe klastrow: K=0; 
%	for i=1..n-1  if C(yi) neq C(yi+1) then K=K+1 else 


clear all;
format short g;

N=2;
nclass=2; 
N2=2^N;
%				generate all bit strings 
for k=0:N2-1
	Points(k+1,:) = bitget(k,[N:-1:1]);
end;
%
M2=2^N2;

% W: Direction of projection

%W=[1/1 1/1];   %    
%W=[0.0 1.0]; %    
%Wmin=W;  % keep this as Wmin

%  Points*W'  gives projection of all N2 points, Boolf gives their labeling
%  Count the distribution of k

%	Find the labeling for each function and determine k=KL
dt=1/3;
Dminmin=0;			% smallest Dmin for all 
for W1=1/3:dt:1/3
for W2=-1/2:dt:-1/2
W=[W1 W2];
Wmin=W; Dmin=M2;
if (sum(abs(W))>0) %  remove W=[0000]

Nsep=zeros(1,N2);   % counter for k; add 2 for 1-sep  
Nsep(1)=2;

for k=2:M2-1   %  remove 00000 and 11111 as 1-sep !
KLmin=N2;

% select one of the Boolean functions, project, check k, and distance
BF= bitget(k-1,[1:N2]);
yp=Points(:,1:N)*W';
[Y,I]=sort(yp);
YP=BF(I);		% reordered vertex labels
KL=sum(abs(YP(2:N2)-YP(1:N2-1)))+1;
Gap=abs(YP(2:N2)-YP(1:N2-1)).*(Y(2:N2)-Y(1:N2-1))';
Dm=min(Gap(find(YP(2:N2)~=YP(1:N2-1))) );
if(Dm>1e-6) 
	KLmin=KL;
end
Dmin=min(Dmin,Dm);

Nsep(KLmin)=Nsep(KLmin)+1;		% calculate k distribution

if(KLmin==2)
fprintf(1,'%3.0f\t %3.0f\t %5.2f\t',[k KL Dm]);
fprintf(1,'\n');				
end

end  % loop over k, Boolean functions


%disp([' 1s  2s  3s  4s  5s  6s  7s  8s  9s ...'])

for k=1:N
fprintf(1,'%5.2f\t',W(k));				
end 
% fprintf(1,'\n');				


for k=1:N2
fprintf(1,'%3.0f\t',Nsep(k));				
end 
fprintf(1,'%8.2f\t',Dmin);				

fprintf(1,'\n');				

end   % ||W||>0
end   % W2
end   % W1

%   dla W=[1 1]  k=2,15, 8,9, daje 2-sep, 7 i 10 3-sep, uwaga: num f. to k-1
%   to odpowiada f.  0001 i 1110; 0111 i 1000, oraz 0110 i 1001 
%   dla W=[1 -1]  k=3,5, 12,14, daje 2-sep, 7 i 10 3-sep, uwaga: num f. to k-1
%   to odpowiada f.  0010 i 1101; 1011 i 0100, oraz 0110 i 1001 
% co sep 4,6,11,13, or 0011, 0101, 1010, 1100  proj 10 i 01

% dla (1/2,2/9) mamy 2,4,8,9,13,15
% dla  (1/3,-1/2) mamy 3,5,6,11,12,14, ortog. kierunki