function data=data_load(inputpath)
% Load data from given location (directory or path to file).
% Returns structures created by DATA_STRUCT.

files = dir(inputpath);
if isdir(inputpath) == 1
    directory=strcat(inputpath,'/');
else
    directory=strcat(fileparts(inputpath),'/');
end

n=size((files),1);
fn=0;

for i=1:n
    try
        if files(i).isdir == 1
            continue
        end
        file=strcat(directory,files(i).name);
        [path datasetname]=fileparts(file);

        d = load(file);
        fn=fn+1;
        data(fn)=data_struct(d,datasetname);
%         data.name=datasetname;
%         [data{fn}.x data{fn}.y]=datap(d);
%         [data{fn}.vectors data{fn}.features]=size(data{fn}.x);
%         data{fn}.classInfo=classstat(data{fn}.y);
%         fprintf('\t\tDATA\n');
%         disp(data(fn));
%         fprintf('\t\t\tLABELS\n');
%         disp(data(fn).classInfo);
        
        
    catch m
        warning(sprintf('Loading dataset %s error\n',files(i).name));
        disp(m);
    end     
end

% if fn == 1
%     data = data{1};
% end