function data=data_struct(x,name,varargin)
% DATA_STRUCT  Create data struct (with labels).
%    D=DATA_STRUCT(X) returns data struct with labels. 
%        Class labels must be given in last column of X table.
% 
%    D=DATA_STRUCT(X,NAME) set data NAME (default 'UnknownData')
%
data.x=x(:,1:end-1);
data.y=x(:,end);
if nargin < 2
    data.name='UnknownData';
else
    data.name = name;
end
[data.vectors data.features]=size(data.x);
data.classInfo=classstat(data.y);
