function [y dy da dt ds]=f_bicentral(x,a,t,slope)
% Y=F_BICENTRAL(X) returns value of bicentral function s(x)(1-s(X)),
%     where s(x) is a sigmoid function 1/(1+exp(-x))
% 
% Y=F_BICENTRAL(X,A,T,S) return value of bicentral function where:
%    A width of function (default A=1)
%    T center of function (default T=0)
%    S slope of function (default S=1)
%
% [Y DY]=F_BICENTRAL(X,A,T,S)  returns value of gradient df/dx

if nargin < 4; slope=1; end;
if nargin < 3; t = 0;   end
if nargin < 2; a = 1;   end

[fxa dfxa] = f_sigm(slope*(x-t+a));
[fxb dfxb] = f_sigm(slope*(x-t-a));

y=fxa.*(1.0-fxb);

if nargout > 1
    d1 = dfxa.*(1-fxb);
    d2 = fxa.*dfxb;
    dy=slope*(d1-d2);
end
if nargout > 2
    da = slope*(d1+d2);
end
if nargout > 3
    dt = -dy;
end
if nargout > 4
   ds = ((x-t+a).*dfxa).*(1-fxb) - fxa .*(dfxb.*(x-t-a));
end
