function [y dy da db ds]=f_bicentral2(x,a,b,slope)
% Y=F_BICENTRAL(X) returns value of bicentral function s(x)(1-s(X)),
%     where s(x) is a sigmoid function 1/(1+exp(-x))
% 
% Y=F_BICENTRAL(X,A,T,S) return value of bicentral function where:
%    A width of function (default A=1)
%    T center of function (default T=0)
%    S slope of function (default S=1)
%
% [Y DY]=F_BICENTRAL(X,A,T,S)  returns value of gradient df/dx

if nargin < 4
    slope=1;
end;
if nargin < 3
	b = 1;
end
if nargin < 2
   a = -1;
end

[fxa dfxa] = f_sigm(slope*(x-b));
[fxb dfxb] = f_sigm(slope*(x-a));

y=fxa.*(1.0-fxb);

if nargout > 1
    da = -(dfxa.*(1-fxb));
    db = (fxa.*dfxb);
    dy = -slope*(da + db);
end
if nargout > 2
    da = slope * da;
    db = slope * db;
end
if nargin > 4
    ds = -da.*(x-a) + db.*(x-b); 
end