function [y dy da ds]=f_sigm(x,a,s)

% Sigmoid function  Y=F_SIGM(X)
% [Y DX]=F_SIGM(X);
%
% or  [Y DX DA DS]=F_SIGM(X,A,S);
%
% Note that: F_SIGM(X,A,S) = F_SIGM(S*(X-A)) 

if nargin < 2; a = 0; end
if nargin < 3; s = 1; end

y = 1./(1+exp(s*(a-x)));

if nargout > 1
    dy = y.*(1-y)*s;
end
if nargout > 2
    da = -s*a*dy;
end
if nargout > 3
    ds = dy.*(x-a);
end

    