function [y dy da ds]=f_sigm(x,a,s)

% Sigmoid function  Y=F_SIGM_INV(X) = (1 - F_SIGM(X))
% [Y DX]=F_SIGM_INV(X);
%
% or  [Y DX DA DS]=F_SIGM_INV(X,A,S);
%
% Note that: F_SIGM_INV(X,A,S) = F_SIGM_INV(S*(X-A)) 

if nargin < 2; a = 0; end
if nargin < 3; s = 1; end

y1 = 1./(1+exp(s*(a-x)));
y = 1 - y1;
if nargout > 1
    dy = -y1.*(1-y1)*s;
end
if nargout > 2
    da = s*a*dy;
end
if nargout > 3
    ds = dy.*(x-a);
end

    