function [bestp bestlvqerr]=glvqtrain(x,y,learningRate)
% growing LVQ learning
% starts with K prototypes (K=number of classes) and
% after learning splits prototypes with missclassify large number of
% samples and repeats learning

nv=size(x,1);
ci = classstat(y);

lvqlr=learningRate;
initp=[];
maxperr = 0.1;
distance=@(x,y)dEuclid(x,y);
maxprot = 100;

%prototypes = zeros(maxprot,nf+1);
stop = 0;

bestlvqerr = 1;
bestp = [];
acc=[];
overtrine = 1;  % przetrenowywanie

% pierwszy przebieg
%prototypes=llvqtrain(x,y,'lvqlr',lvqlr,'initp',initp,'linear','no','dead','transfer','display','none');
prototypes=lvq(x,y,'lvqlr',lvqlr,'initp',initp,'dead','leave','display','none');

%   prototypes=llvqtrain(x,y,'lvqlr',lvqlr,'initp',initp,'linear','no','dead','leave');
[lvqerr pn]=lvqerror(x,y,prototypes);
protn = size(prototypes,1);
bestlvqerr = lvqerr;
bestp = prototypes;
lvqlr2 = lvqlr;

while stop == 0

        
        %     Md=(pn(:,1)-pn(:,2))./nv;
%     proc=100*pn./nv;
%     num=size(prototypes,1);
%     Md2=(pn(:,1)-pn(:,2));
%     Md3=pn(:,2)./(pn(:,1)+pn(:,2));
%     for i=1:num
%         Md2(i)=Md2(i)/labelsPerClassCount(labels==prototypes(i,end));
%     end
%     clf;
%     scaterplot(x,y);
%     hold on;
%     scaterplot(prototypes(:,1:end-1),prototypes(:,end),'select','yes','borders','yes');
    
    
    
%    if pn(im,2)/(pn(im,1)+pn(im,2)) >= maxperr;  

    [nns ins]=sort(pn(:,2),'descend');

    pi =1;

    figure(1);
    clf;
    scaterplot(x,y);
    hold on;
    scaterplot(prototypes(:,1:end-1),prototypes(:,end),'select','yes','borders','yes');
    drawnow;
    
    while pi <= protn
          if nns(pi)==0
            stop = 1;
            fprintf('STOP: Error do not decrease any more\n')
            break;
          end
            
        cerrcount=zeros(1,ci.labelsCount);
        errid=zeros(1,pn(ins(pi),2));
        errlab=zeros(1,pn(ins(pi),2));

        ei = 1;
        for i=1:nv
            [I S]=lvq1(bestp,x(i,:),y(i),distance);
            if ins(pi) == I && S == -1
                errid(ei)=i;
                errlab(ei)=y(i);
                yid= y(i)==ci.labels;
                cerrcount(yid) = cerrcount(yid) + 1; 
                ei = ei + 1;  
            end
        end

        [cm cmid]=max(cerrcount);
        
        if length(errid) ~= 1
            pxn=mean(x(errid(ci.labels(cmid)==y(errid)),:));
        else
            pxn=x(errid,:);
        end

        fprintf('Adding prototype %d\n',protn+1);
        initp=[bestp; pxn ci.labels(cmid)];
        
%         figure(2);
%         clf;
%         scaterplot(x,y);
%         hold on;
%         scaterplot(initp(:,1:end-1),initp(:,end),'select','yes','borders','yes');
%         drawnow;
% 
%         pause;
        
%        prototypes=llvqtrain(x,y,'lvqlr',lvqlr2,'initp',initp,'linear','no','dead','transfer','display','none');
        prototypes=lvq(x,y,'lvqlr',lvqlr2,'initp',initp,'dead','transfer','display',0);
        [lvqerr cpn]=lvqerror(x,y,prototypes);
%        acc=[acc; 100*(1-lvqerr)]
            
        if lvqerr < bestlvqerr || overtrine == 1;
            bestlvqerr = lvqerr;
            bestp = prototypes;
            lvqlr2=lvqlr2*0.8;
            pn = cpn;
            protn = protn + 1;
            fprintf('OK, this prototype is good\n');
            break;
        else
            fprintf('NO, This prototype is WRONG\n');
        end
        pi = pi+1;
     end
            
    if protn >= maxprot 
        fprintf('Stop: Max prototypes reached\n');
        stop =1;
    end

    if pi == protn+1
        fprintf('Stop: All prototypes checked\n');
%        stop =1;
    end
end

%acc = 100*(1-lvqerror(x,y,prototypes));
return
    
    % zajac sie martwymi prototypami - na razie tak
%     deadp = pn(:,1)+pn(:,2) == 0;
%     if nnz(deadp) > 0
%       px=trnsfer(x,y,prototypes,deadp);
%       prototypes(:,1:end-1)=px;
%     end
    
    

[nv nf]=size(x);

[labels a index] = unique(y);
labelsCount = size(labels,1);

%labelsIndex = zeros(vectorsCount,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

%if nargin < 3 || k < labelsCount; k =labelsCount; end
k = labelsCount;
if nargin < 3 ; learningRate = 0.05 ;end
maxIterations = k*50;

labelsIndex = zeros(nv,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

for i=1:labelsCount
    labelsIndex(:,i) = (index == i);
end
labelsPerClassCount=sum(labelsIndex);
%cf = labelsPerClassCount./nv;
    
prototypes = zeros(k,nf+1);

[Y I]=sort(labelsPerClassCount,'descend');
prototypesCount=1+floor((k-labelsCount)*labelsPerClassCount./nv);

rest=k-sum(prototypesCount);
for i=1:rest
    prototypesCount(I(i))=prototypesCount(I(i))+1;
end

    
    % position inicjalization
n=1;
for i=1:labelsCount
    vid=randperm(labelsPerClassCount(i));
    pc=prototypesCount(i);
    zz=x(y==labels(i),:);
    for j=1:pc
        id=vid(j);
        prototypes(n,:)=[ zz(id,:) labels(i)];
%        prototypes(n,end)=labels(i);
%       prototypes(n,:)=[ rand(1,nf)*2-1 labels(i)];

       n=n+1;
    end
end

lvqerr=zeros(1,maxIterations);
% nupdate = k; % how often do linearization (1 - each iterationa, nv - each epoch)
llrate=0.01;

stop = 0;
ne=1;
avgtest= 3;
avgerr = 1;
%lastavgerr = 1;
wp=rand(1,nf); wp=wp/norm(wp);
%numbe of epoches

maxLRate = 0.5;
px = prototypes(:,1:end-1);
py = prototypes(:,end);
lvqerr= [];
distance=@(x,y)dEuclid(x,y);
lrate=ones(1,k)*learningRate;
eps = 0.01;
linear = 0; % do linearization

ilvqerr=lvqerror(x,y,[px py]);
%[step lerr wp]=linearization_pca(px);
illvqerr=lvqerror(x*wp',y,[px*wp' py]); %error after projection
fprintf('ep   0 Elvq %6.4f Ellvq %6.4f [ ',ilvqerr,illvqerr);
fprintf('%3.2f ',wp);
fprintf(']\n');
cfr = 1;

while stop == 0
    id = randperm(nv);
    for ni=1:nv     % number of iterations
        % LVQ1 
        [pid S]=lvq1([px py],x(id(ni),:),y(id(ni)),distance);
        
        lr=lrate(pid);
        px(pid,:)=px(pid,:)+cfr*S*lr*(x(id(ni),:)-px(pid,:));
        
        lrate(pid)=lr/(1+S*lr);
        if lrate(pid) > maxLRate; lrate(pid)=maxLRate; end

        if mod((ne-1)*nv+ni,nupdate) == 0 && linear == 1
            if k == 2
                wp=px(1,:)-px(2,:);
                wp=wp/norm(wp);
                lerr=0;
            else
               [step lerr wp]=linearization_pca(px);
    %           [step lerr wp]=linearization_qpc(px,py);
               px=px-llrate*step;
            end
        end
    end
    
%   lvqlr=learningRate*exp(-ne./B);
     [lvqerr(ne) pn]=lvqerror(x,y,[px py]);
     llvqerr=lvqerror(x*wp',y,[px*wp' py]); %error after projection
%     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f Elin %6.4f [ ',ne,lvqerr(ne),llvqerr,lerr);
     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f [ ',ne,lvqerr(ne),llvqerr);
     fprintf('%3.2f ',wp);
     fprintf(']\n');

%          clf;
%     bgraph3(x*wp',y);
%     bgraph3(px*wp',py,'select','yes');

     deadp = pn(:,1)+pn(:,2) == 0;
     if nnz(deadp) > 0
        px=trnsfer(x,y,[px py],deadp);
        lrate(deadp)=learningRate;
         [lvqerr2 pn2]=lvqerror(x,y,[px py]);
         llvqerr2=lvqerror(x*wp',y,[px*wp' py]); %error after projection
%     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f Elin %6.4f [ ',ne,lvqerr(ne),llvqerr,lerr);
    
        fprintf('TUNELING\nep %3d Elvq %6.4f Ellvq %6.4f \n ',ne,lvqerr2,llvqerr2);
     end

     
     
    % plot(lvqerr);

     
     
%      a=sum(pn)/nv;
%      disp(100*pn./nv);
    %     ',ne,lvqerr(ne),llvqerr,lerr);
%     clf;
%     scaterplot(x,y,1:3);
%     hold on;
%     scaterplot(px,py,1:3,'select','yes');
%     hold off;
%     clf;
%     bgraph3(x*wp',y);
%     bgraph3(px*wp',py,'select','yes');
%     ah=bgraph3(x*wp',y);
%     axes(ah(2));
%     hold on;
% 
%     for ci=1:labelsCount
%         pp=px(py==labels(ci),:);
%         plot(pp*wp',ones(size(pp)).*ci,'ok');
%     end
%     hold off;
     drawnow;

    if mod(ne,avgtest) == 0 
         lastavgerr = avgerr;
         avgerr = mean(lvqerr(ne-avgtest+1:ne));

        if abs((avgerr - lastavgerr)/lastavgerr) < eps && ne > 1  
           stop = 1;
           fprintf('STOP: Error does not change to much\n');
%            fprintf('ep %3d Elvq %6.4f Ellvq %6.4f lr %4.3f Elin %6.4f llr %4.3f [ ',ne,lvqerr(ne),llvqerr,lvqlr,lerr,llrate);
%            fprintf('%3.2f ',wp);
%            fprintf(']\n');
%            plot(lvqerr);
%            clf;
%            bgraph3([x ; prototypes(:,1:end-1)]*wp',[y ; ones(k,1)+3]);
%            drawnow;
        end;
    end;

    if ne>= maxIterations
        stop =1 ;
        fprintf('STOP: Max Iterations (%d) reached\n',maxIterations);
    end
    if norm(lrate) < eps 
        stop = 1;
        fprintf('STOP: LVQ learning rate drops to much\n');
    end
    ne=ne+1;
end
bestw=wp;
accerr=llvqerr;
prototypes=[px py];


function newpx=trnsfer(x,y,p,dead)

nv=size(x,1);
np=size(p,1);
distance=@(x,y)dEuclid(x,y);
%rest=nnz(dead);
didx=find(dead);

for di=didx'
    cc = p(di,end);
    id = randperm(nv);    
    for i=1:nv
        if y(id(i))== cc
            [I S]=lvq1(p,x(id(i),:),y(id(i)),distance);
            if S == -1
                p(di,1:end-1)=x(id(i),:);
                break;
            end
        end
    end
end
newpx=p(:,1:end-1);
