function [wp dislocation  err]=linearization_pca(x)
% FUNCTION [W D E]=LINEARIZATION_PCA(x)
% dorection fitting using 1-st PCA eigenvector - unsupervised
%
% W - direction
% D - disslocation, shifr from origin centre ( Y=WX-D ??)
% E - squer euclidean error 

w=princomp(x,'econ');
wp=w(:,1)';

if nargout > 1
    nv=size(x,1);
    mx=mean(x);
    c=x-ones(nv,1)*mx;           % data centering x-mean(x)
    p=c*wp'*wp;                  % projection
    dislocation = c-p;   
end
if nargout > 2
    err = sum(sum((c-p)'.^2))/nv;
end

