function [acc labels]=llvqnettest(x,y,net)
% LLVQNETTEST(X,Y,NET) accuracy test on X dataset with labels Y for network NET
% obtained by LLVQNETWORK learning
%    
%  ACC = LLVQNETTEST(X,Y,NET) returns ACCuracy value
%  [ACC LABELS]= LLVQNETTEST(X,Y,NET) returns predicted LABELS

vectorsCount = size(x,1);
labels = zeros(vectorsCount,1);
distance=@(x1,x2)dEuclid(x1,x2);

wx =x*net.w';
nv = size(x,1);

for i=1:nv
    xx = ones(net.np,1)*wx(i,:);
     [Y I]=min(distance(net.p(:,1:end-1),xx),[],1);  %
     labels(i)=net.p(I,end);
end
acc=100.0 *(1.0 - sum(labels ~= y)/vectorsCount);
