function [bestw bestp besterr]=llvqoptimize3(x,y,krange,lvqlr,proj,init,dataname)
% LVQ z rosnaca ilocia prototypow -> QPC na prototypach
% DATANAME - text string 

%init=10;
%lvqlr=0.05;
%proj=4;

[nv nf]=size(x);
labels = unique(y);
labelsCount = size(labels,1);
qpcrate = 0.1;

%labelsIndex = zeros(vectorsCount,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0
if length(krange) == 2;
    mink=krange(1);
    maxk=krange(2);
else
    mink=labelsCount;
    maxk=krange;
end

% mink = labelsCount;
% if maxk <= mink
%     maxk=mink;
% end


if proj>nf
    proj = nf;
end

%x1=zeros(nv,proj);

savedir     = strcat(datestr(now,'yy.mm.dd'),'.llvq_results/');
[s comment]=mkdir(savedir);
if s == 0
     error(comment);
end

prefix=strcat(savedir,sprintf('%s.llvq.qpc.r8',dataname));
f=fopen(strcat(prefix,'.log'),'w');
if f == -1
    error('Cannot open file');
end
fprintf(f,'Dataname        %s\n',dataname);
fprintf(f,'Vectors         %d\n',nv);
fprintf(f,'Features        %d\n',nf);
fprintf(f,'Classes         %d [ %s]\n',labelsCount,sprintf('%d ',labels));
fprintf(f,'Procedure       lvq1+qpc\n');
fprintf(f,'K range         %d-%d\n',mink,maxk);
fprintf(f,'LVQ lrate       %.3f\n',lvqlr);
fprintf(f,'QPC lrate      %.3f\n',qpcrate);
fprintf(f,'Projections     %d\n',proj);
fprintf(f,'Initializations  %d\n',init);

% besterr=1;
% besti = 0;
% bestk= 0;


[nv nf]=size(x);
% serr=zeros(proj,1);   % single projection error
I=eye(nf);
lasterr = 1.0;
bestpi=1;

[p lvqerr]=findbestprototypes(x,y,mink:maxk,lvqlr,init,prefix);
px=p(:,1:end-1);
py=p(:,end);

currw = zeros(proj,nf);
currerr = zeros(proj,1);
currp = zeros(size(p,1),proj+1);

for pi=1:proj  % number of projections
    fprintf('Projection %d\n',pi);
  
    
    if pi == 1
        P = [];
        x1 = x;
        y1 =y;
        initp=p;
    else
         P=I-currw'*currw;  % operator projekcji na podprz. otronormalna
%         nv2=size(xp,1);
%         errtab=zeros(1,nv);
%          for i=1:nv
%              [I errtab(i)]=lvq1([currp(:,1:pi-1) prot(:,end)],x(i,:)*currw(1:pi-1,:)',y(i));
%          end
%          learnid = errtab == -1;
%          a=nnz(learnid);
%          b=a/nv;
%          xp=x(learnid,:)*P;        
%          yp=y(learnid);
          x1=x*P;
%          initp=[px(:,1:end-1)*P py];
%            zzz=px*P
          [prot w1 err]=llvqtrain(x1,y1,lvqlr,'linear','no','initp',[px*P py]);          
%          initp=[prot(:,1:end-1)*P prot(:,end)];
          px=prot(:,1:end-1);
    end

    attempts=5;
    [p wb]=findprojectionwithprototypes(x1,y,px,py,attempts,lvqlr);
    
    if pi > 1
        w=wb*P;
    else
        w=wb;
    end

    currw(pi,:)=w;
    currp(:,pi)=px*wb'; 
    currerr(pi)=lvqerror(x*currw(1:pi,:)',y,[currp(:,1:pi) py]);
 %   serr(pi)=err;

     if pi > 1 && lasterr <= currerr(pi)
        bestpi=pi-1;
        fprintf('STOP: Next projection give worse results\n');
        break;
    end
    lasterr = currerr(pi);
end
bestw=currw(1:bestpi,:);
bestp=[currp(:,1:bestpi) prot(:,end)];
besterr=currerr(1:bestpi);

%  prefix = sprintf('%s.D%d',pref,pi);

pn=size(bestp,1);
fprintf(f,'\nPrototypes %d\n',pn);
for ki=1:pn
    fprintf(f,'%s %d\n',sprintf(' %.3f',bestp(ki,1:end-1)),p(ki,end)); 
end

wn=size(bestw,1);
for pi=1:wn
    fprintf(f,'acc %4.2f w [ %s ]\n',(1-currerr(pi))*100,sprintf(' %.3f',bestw(pi,:))); 
end
fprintf(f,'\nBest projection %d with k=%d, acc %.2f\n',wn,pn,(1-besterr)*100);
fclose(f);

if wn == 1
        clf;
         bgraph3(x*bestw',y);
         hold on;

         bgraph3(bestp(:,1:end-1),bestp(:,end),'select','yes','borders','yes');% ,'borders','yes');         
         print('-dpng','-r96',sprintf('%s.bgraph.png',prefix));
else
         clf;
         scaterplot(x*bestw',y,1:wn);
         hold on;
         scaterplot(bestp(:,1:end-1),bestp(:,end),1:wn,'select','yes','borders','yes');         
         print('-dpng','-r96',sprintf('%s.all.scatter.png',prefix));
end



return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [bp bw]=findprojectionwithprototypes(x,y,px,py,attempts,lvqlr)


%feat=1:size(x,2);
for i=1:attempts
%     figure(2);
%     clf;
%     scaterplot(x,y,feat);
%     scaterplot(px,py,feat,'select','yes');
%     drawnow;
    if i > 1
        [p2 w2 err2]=llvqtrain(x,y,'lvqlr',lvqlr/i,'initp',[px py],'linear','no');
        px=p2(:,1:end-1);
    end
    
    [dislocation err w]=linearization_qpc(x,y,px,py);
    px=px-dislocation;
end
bw=w;
bp=[px py];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [bestp besterr]=findbestprototypes(x,y,krange,lvqlr,init,prefix)

bestp=[];
besterr = 1;
for k=krange
    fprintf('Prototypes %d ',k);     
%    prefix = sprintf('%s.k%d',pref,k);
 
    [p err]=findlvqbestinitiation(x,y,k,lvqlr,init,prefix);
%    [Y I]=min(lvqerr);
    if err<besterr || isempty(bestp)
        besterr = err;
%        bestk=k;
        bestp=p;
    end
    
%    fprintf('Prototypes %d lvqEr %0.3f\n',k,err);
%     for ki=1:k
%         fprintf(f,'%s %d\n',sprintf(' %.3f',p(ki,1:end-1)),p(ki,end)); 
%     end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [bestw bestp besterr serr]=llvqprojectionsequence(x,y,k,lvqlr,proj,init,pref)
% find best projection (from 1 to PROJ projections) whith given K number of
% prototypes, PREF - text string 

[nv nf]=size(x);
currw = zeros(proj,nf);
currerr = zeros(proj,1);
currp = zeros(k,proj+1);
serr=zeros(proj,1);   % single projection error
I=eye(nf);
lasterr = 1.0;
bestpi=1;

learnid=ones(1,nv);

for pi=1:proj  % number of projections
    fprintf('Projection %d\n',pi);
    prefix = sprintf('%s.D%d',pref,pi);
    
    if pi == 1
        P = [];
        xp = x;
        yp=y;
        initp=[];
    else
         P=I-currw'*currw;  % operator projekcji na podprz. otronormalna
%         nv2=size(xp,1);
         errtab=zeros(1,nv);
         for i=1:nv
             [I errtab(i)]=lvq1([currp(:,1:pi-1) prot(:,end)],x(i,:)*currw(1:pi-1,:)',y(i));
         end
         learnid = errtab == -1;
         a=nnz(learnid);
         b=a/nv;
         xp=x(learnid,:)*P;        
         yp=y(learnid);
         initp=[prot(:,1:end-1)*P prot(:,end)];
    end
    
    [wb prot err]=findlvqbestprojection(xp,yp,k,lvqlr,init,prefix,initp);

    % douczanie
    if pi > 1
        w=wb*P;
    else
        w=wb;
%         porig = prot;
    end

    currw(pi,:)=w;
    currp(:,pi)=prot(:,1:end-1)*wb'; 
    currerr(pi)=lvqerror(x*currw(1:pi,:)',y,[currp(:,1:pi) prot(:,end)]);
    serr(pi)=err;

%     if pi > 1
%         figure(1);
%         clf;
%         scaterplot(x*currw(1:pi,:)',y);
%         scaterplot(currp(:,1:pi),prot(:,end),1:pi,'select','yes','borders','yes');
%         drawnow;
%     end

%    [p2 w2 err2]=llvqtrain(x*currw(1:pi,:)',y,'initp',[currp(:,1:pi) prot(:,end)],'linear','no','lvqlr',0.005);
%     if pi > 1
%         figure(2);
%         clf;
%         scaterplot(x*currw(1:pi,:)',y);
%         scaterplot(p2(:,1:pi),p2(:,end),1:pi,'select','yes','borders','yes');
%         drawnow;
%     end

%     err3=lvqerror(x*currw(1:pi,:)',y,p2);
%      if err2 < currerr(pi)
%          currerr(pi) = err2;
%          currp(:,1:pi)=p2(:,1:pi);
%      end
%     if pi > 1
%         figure(3);
%         clf;
%         scaterplot(x*currw(1:pi,:)',y);
%         scaterplot(currp(:,1:pi),prot(:,end),1:pi,'select','yes','borders','yes');
%         drawnow;
%     end


     
    if pi > 1 && lasterr <= currerr(pi)
        bestpi=pi-1;
        fprintf('STOP: Next projection give worse results\n');
        break;
    end
    lasterr = currerr(pi);
end
bestw=currw(1:bestpi,:);
bestp=[currp(:,1:bestpi) prot(:,end)];
besterr=currerr(1:bestpi);

[p2 w2 err2]=llvqtrain(x*bestw',y,'initp',[bestp(:,1:end-1) bestp(:,end)],'linear','no','lvqlr',0.005);
if err2 < besterr(bestpi);
    besterr(bestpi)=err2;
    bestp=p2;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [bp berr]=findlvqbestinitiation(x,y,k,lr,init,prefix)
% finds best projections from INIT initalizations of learning whit given K
% number of prototypes

berr = 1;
bi=1;

% f=fopen(strcat(prefix,'.log'),'w');
% if f==-1
%     error('Cannot open file');
% end

for ii=1:init  % number of trials per projection
%     fprintf('Init %d : ',ii);    fprintf(f,'Init %d : ',ii);
    [p w err]=llvqtrain(x,y,k,lr,'linear','no');
    if err < berr
        berr = err;
        bp=p;
%        bw=w;
        bi=ii;
    end
 %   fprintf('acc %3.1f w [ %s ]\n',100*(1-err),sprintf('%4.2f ',w));

    %     fprintf(f,'acc %4.2f w [ %s ]\n',100*(1-err),sprintf('%6.3f ',w));

%    clf;
%     str={sprintf('acc %.2f',100*(1-err)), sprintf('k %d',k)};
%     bgraph3([x ; p(:,1:end-1)]*w',[y ; ones(k,1)-2],'str',str);
%   	print('-dpng','-r96',sprintf('%s.%02d.png',prefix,ii));
end
fprintf('Init %d/%d was the best, acc %3.1f\n',bi,init,100*(1-berr));
% fprintf(f,'Init %d was the best, acc %5.2f w [ %s ]\n',bi,100*(1-berr),sprintf('%6.3f ',bw));
% fclose(f);
