function [bestw bestp besterr]=llvqoptimize4(x,y,krange,lvqlr,proj,init,dataname,linearizator,epsilon,display)
% LVQ z rosnaca ilocia prototypow + linearyzacja
% po nauczeniu kierunku zwikszamy liczbe prototypow i douczamy
% potem douczamy w nowej podprzestrzeni 1D, 2D, 3D itd.
% odpowiednio dobieramy modele, preferujac te mniej zlozone, chyba, ze 
% dodanie prototypu lub wymiaru poprawia klasyfikacje
% dodane mechanizmy zapobiegajace przeuczaniu
% DATANAME - text string 

%init=10;
%lvqlr=0.05;
%proj=4;

[nv nf]=size(x);
labels = unique(y);
labelsCount = size(labels,1);
%qpcrate = 0.1;
llrate =0.05;
%labelsIndex = zeros(vectorsCount,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

if nargin < 3 || isempty(krange);   krange = labelsCount:labelsCount; end
if nargin < 4 || isempty(lvqlr);     lvqlr = 0.05; end
if nargin < 5 || isempty(proj);     proj = nf; end
if nargin < 6 ;    init = 5; end


log = 1;
if proj>nf ;    proj = nf; end
if nargin < 7 || isempty(dataname) ;    dataname = 'data';     log = 0; end
if nargin < 8
    linearizator=@(x,y,ik,ip)llvqtrain(x,y,ik,'initp',ip,'lvqlr',lvqlr,'llrate',llrate,'llupdate',10);  
%      linearizator=@(x,y,ik,ip)llvqtrain2(x,y,ip,ik,lvqlr,5,1);
end
if nargin < 9;  epsilon = 0.03; end
if nargin < 10;  display = 0; end

prefix = [];
%x1=zeros(nv,proj);
if log == 1
    savedir     = strcat(datestr(now,'yy.mm.dd'),'.llvq_results/');
    [s comment]=mkdir(savedir);
    if s == 0
         error(comment);
    end
    prefix=strcat(savedir,sprintf('%s.r8',dataname));
end

bestp=[];
besterr=1;
bestw=[];
bestik = [];
bestpn = 0;
[v f]=size(x);


for k=krange
    if display > 0
        fprintf('Init K=%d\n',k);
    end
    if log == 1
        prefix1=sprintf('%s.ik%d',prefix,k);
    else
        prefix1 = [];
    end
    
    [p w err]=trainllvqnetwork(x,y,k,lvqlr,proj,init,linearizator,epsilon,prefix1,display);
%    [w p err]=llvqoptimize4(x,y,k,lvqlr,proj,ni,filename,linearizator);
    pn=size(p,1);
    wn = size(w,1);
    param = wn*(f-1) + wn*pn;
    if k==krange(1)
        bestp = p;
        bestw = w;
        bestwn = wn;
        besterr = err;
        bestpn = pn;
        bestik = k;
        bestparam = param;
%                 bestik =k;
    else
        if ( err <= besterr && param < bestparam ) || err+epsilon < besterr 
            besterr = err;
            bestp = p;
            bestw = w;
            bestik = k;
            bestpn = pn;
            bestwn = wn;
            bestparam = param;
%                       bestik = k;
        end
    end
end

wn=size(bestw,1);

if log == 1
    fname=sprintf('%s.best.w%d.k%d.txt',prefix,bestwn,bestpn);
    f = fopen(fname,'w');

    fprintf(f,'Dataname          %s\n',dataname);
    fprintf(f,'Vectors           %d\n',nv);
    fprintf(f,'Features          %d\n',nf);
    fprintf(f,'Classes           %d [ %s]\n',labelsCount,sprintf('%d ',labels));
    fprintf(f,'Procedure         growing lvq1+pca (lub qpc)\n');
    fprintf(f,'Linearizator      %s\n',func2str(linearizator));
    fprintf(f,'K range           %s\n',sprintf('%d ',krange));
    fprintf(f,'LVQ lrate         %.3f\n',lvqlr);
    fprintf(f,'Lin. rate         %.3f\n',llrate);
    fprintf(f,'Max. Projections  %d\n',proj);
    fprintf(f,'Initializations   %d\n',init);

    fprintf(f,'\nBest solution\n');
    fprintf(f,'Projections %d, prototypes %d, accuracy = %.2f, init K %d\n',wn,bestpn,100*(1-besterr),bestik);
    fprintf(f,'Prototypes\n');
    for ki=1:bestpn
        fprintf(f,'%s %d\n',sprintf(' %.3f',bestp(ki,1:end-1)),bestp(ki,end)); 
    end

    fprintf(f,'\nWeights\n');

    fprintf(f,'%s\n',sprintf(' %5dF',1:size(w,2))); 
    for pi=1:wn
        fprintf(f,'%s\n',sprintf(' %6.3f',bestw(pi,:))); 
    end
    fclose(f);
    
    plotresult(x,y,bestw,bestp,fname);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [bestp bestw besterr]=trainllvqnetwork(x,y,initk,lvqlr,proj,init,linearizator,epsilon,prefix,display)

if ~isempty(prefix)
    f=fopen(strcat(prefix,'.log'),'w');
    if f == -1
        error('Cannot open file');
    end
    
%fprintf(f,'Dataname        %s\n',dataname);

    fprintf(f,'Linearizator      %s\n',func2str(linearizator));
    fprintf(f,'Init K            %d\n',initk);
    fprintf(f,'LVQ lrate         %.3f\n',lvqlr);
    fprintf(f,'Max. Projections  %d\n',proj);
    fprintf(f,'Initializations   %d\n',init);

end
besterr=[];
bestw=[];
bestp=[];
bestnp=[];

stop = 0;

for pi=1:proj  % number of projections
    if display > 0
        fprintf('Projection %d\n',pi);
    end
    
    if pi == 1
        [p w err]=findfirstprojectionInit(x,y,initk,init,linearizator,epsilon,display);
        besterr = err;
        bestw = w;
        bestp = p;
        np = size(p,1);
        bestnp = np;
    else
        [p w err]=findnextprojection(x,y,bestp,linearizator,epsilon,bestw);
        np = size(p,1);
        
        if  err+epsilon < besterr 
            besterr = err;
            bestp = p;
            bestw = w;
            bestnp = np;
        else
            stop = 1;
        end
    end
    fprintf('BEST projection %d k=%d acc=%.2f Final\n',pi,np,100*(1-err));
    fprintf('w [ %s ]\n',sprintf('%.3f ',w(pi,:)));    

    if ~isempty(prefix)

        fprintf(f,'\nProjection %d final k=%d, acc=%.2f\n',pi,np,100*(1-err));    
        fprintf(f,'w [ %s ]\n',sprintf('%.3f ',w(pi,:)));    
    end
    if stop == 1
        break
    end
    
end

wn=size(bestw,1);

if ~isempty(prefix)

    fprintf(f,'\nBest solution\n');
    fprintf(f,'Projections %d, prototypes %d, accuracy = %.2f\n',wn,bestnp,100*(1-besterr));
    fprintf(f,'\nBest solution\n');
    fprintf(f,'Prototypes\n');
    for ki=1:bestnp
        fprintf(f,'%s %d\n',sprintf(' %.3f',bestp(ki,1:end-1)),bestp(ki,end)); 
    end

    fprintf(f,'\nWeights\n');

    fprintf(f,'%s\n',sprintf(' %5dF',1:size(w,2))); 
    for pi=1:wn
        fprintf(f,'%s\n',sprintf(' %6.3f',bestw(pi,:))); 
    end
    fclose(f);
    plotresult(x,y,bestw,bestp,prefix)
end
return


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plotresult(x,y,w,p,prefix)

wn=size(w,1);
if wn == 1
        clf;
         bgraph3(x*w',y);
         hold on;

         bgraph3(p(:,1:end-1),p(:,end),'select','yes','borders','yes');% ,'borders','yes');         
         print('-dpng','-r96',sprintf('%s.bgraph.png',prefix));
else
         clf;
         scaterplot(x*w',y,1:wn);
         hold on;
         scaterplot(p(:,1:end-1),p(:,end),1:wn,'select','yes','borders','yes');         
         print('-dpng','-r96',sprintf('%s.all.scatter.png',prefix));
end
return;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [bestp bestw besterr]=findnextprojection(x,y,p,linearizator,epsilon,w)
% orthogonal projection to W and prototypes an new hoden neuron learning 
    % X org. space
    % Y labels
    % INITP prototypes in org. space (?)
    % LINEARIZATORATOR function handler
    % EPSILON precision
    % w - weights (hiden layer)

I=eye(size(x,2));
P=I-w'*w;  % operator projekcji na podprz. otronormalna

% lekko rozsuwamy aby zainicjowac w prz. ortogonalnej
p0 = llvqtrain(x,y,'initp',[p(:,1:end-1)*w p(:,end)],'lvqlr',0.01,'linear','no','maxiterations',5);

%err0=lvqerror(x*w',y,p);
%fprintf('k=%d acc=%.2f After Spliting\n',size(p0,1),100*(1-err0));

p_ort=[p0(:,1:end-1)*P p(:,end)];
x_ort = x*P;

% kierunek w p-no ortogonalnej
[p1 w1 ]=linearizator(x_ort,y,0,p_ort);
%fprintf('k=%d acc=%.2f After Linearization\n',size(p1,1),100*(1-err1));

bestnp = size(p,1);
bestw=[w; w1*P];
% prototypy w p-ni w. ukrytej
bestp=[p(:,1:end-1) p1(:,1:end-1)*w1' p(:,end)];

besterr=lvqerror(x*bestw',y,bestp);
%fprintf('k=%d acc=%.2f In hidden space\n',size(bestp,1),100*(1-besterr));

% bestp = pw1;
% besterr = err0;
% bestw = neww;

%id=1:bestnp;
i = 1;
stop =0;
while stop == 0
    %rozszczepienie (w przestrzeni wartstwy ukrytej)
    [p2 newid]=lvqcreatenewprototype(x*bestw',y,bestp,1:bestnp);  
%    id = id(newid);
    % prototypy w ortogonalnej p-ni wejsciowej (?)
    ppx2=[p2(:,1:end-1)*bestw*P p2(:,end)];

    % next projection
    [p3 w3 ]=linearizator(x_ort,y,0,ppx2);
 %   fprintf('k=%d acc=%.2f After Spliting\n',size(p3,1),100*(1-err3));

    neww2=[w; w3];
%    fprintf('DEBUG i=%d newid=[%s] \n',i,sprintf(' %d',newid));
    ppx3=[bestp(newid,1:end-2) p3(:,1:end-1)*w3'];

%    err0=lvqerror(x*neww2',y,[ppx3 p3(:,end)]);
  %  fprintf('k=%d acc=%.2f In hidden space\n',size(ppx3,1),100*(1-err0));

    [p4 err4 ]=removeprototypes(x*neww2',y,[ppx3 p3(:,end)]);
  %  fprintf('k=%d acc=%.2f After Merging\n',size(p4,1),100*(1-err4));
 %   id = id(select==1);
    
    np2=size(p4,1);
    if ( err4 <= besterr && np2 < bestnp ) || err4+epsilon < besterr 
            besterr = err4;
            bestp=p4;
            bestw = neww2;
            bestnp = np2;
    else
        stop = 1;
    end
    i = i + 1;
 %   fprintf('%d acc=%.2f np=%d bestacc=%.2f bestnp=%d\n',i,100*(1-err4),np2,100*(1-besterr),bestnp);
end
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [bestp bestw besterr]=findfirstprojectionInit(x,y,k,init,linearizator,epsilon,display)
% powtarza szukanie kierunku findfirstprojection init razy i wybiera
% najlepsze rozwiazanie

bestp=[];
besterr=1;
bestw=[];
bestpn = 0;

for i=1:init
    if display > 1
        fprintf('Initiation %d\n',i);
    end
    
     [p w err]=findfirstprojection(x,y,k,linearizator,epsilon,display);
     pn=size(bestp,1);
     if i==1
         bestp =p;
         bestw = w;
         besterr = err;
         bestpn = pn;
     else
        if ( err <= besterr && pn < bestpn ) || err+epsilon < besterr 
            besterr = err;
            bestp=p;
            bestw = w;
            bestpn = pn;
        end
     end
end  % Init
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [bestp bestw besterr]=findfirstprojection(x,y,k,linearizator,epsilon,display)
% poczynajac od k prototypow szuka najlepszego kierunku 
% z prototypami potem zwieksza ilosc prototypow w miejscach gdzie
% popelniane za bledy, potem douczanie i usuwanie zbednych prototypow
% jesli sytuacja sie poprawia to powtarzamy

stop = 0;
if nargin < 5; epsilon = 0.03; end

%[bestp bestw besterr]=llvqtrain(x,y,k,'lvqlr',lvqlr,'llrate',llrate,'llupdate',10);
[bestp bestw]=linearizator(x,y,k,[]);
[bestp besterr select]=removeprototypes(x*bestw',y,[bestp(:,1:end-1)*bestw' bestp(:,end)]);

pn1=nnz(select);
while stop == 0
    if display > 2;
        fprintf('Searching for new solution\n ');
    end
    pnew = [bestp(:,1:end-1)*bestw bestp(:,end)];  % prototypy na prostej
    p2=lvqcreatenewprototype(x,y,pnew,1:pn1);
    [p2 w2]=linearizator(x,y,k,p2);
    [p2 err2 select]=removeprototypes(x*w2',y,[p2(:,1:end-1)*w2' p2(:,end)]);
    
    pn2 = nnz(select);
    if ( err2 <= besterr && pn2 < pn1 ) || err2+epsilon < besterr 
        besterr = err2;
        bestp = p2;
        bestw = w2;
        pn1 = pn2;
    else
        stop =1;
    end
end
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% function [bestp bestw besterr]=findfirstprojectionK(x,y,krange,init,f,linearizator,epsilon)
% 
% %epsilon = 0.03; % 
% bestp=[];
% besterr=1;
% bestw=[];
% bestpn = 0;
% 
% for k=krange
%     fprintf('\nInit learning for k=%d\n',k);
%     [p w err]=findfirstprojectionInit(x,y,k,init,linearizator,epsilon);
% 
%     pn=size(p,1);
%     fprintf(f,'\nInit k=%d final k=%d, acc=%.2f\n',k,pn,100*(1-err));
%     fprintf(f,'w [ %s ]\n',sprintf('%.3f ',w));
%     for ki=1:pn ; fprintf(f,'%s %d\n',sprintf(' %.3f',p(ki,1:end-1)),p(ki,end));  end
% 
%     if k==krange(1)
%          bestp = p;
%          bestw = w;
%          besterr = err;
%          bestpn = pn;
%      else
%         if ( err < besterr && pn <= bestpn ) || err+epsilon < besterr 
%             besterr = err;
%             bestp=p;
%             bestw = w;
%             bestpn = pn;
%         end
%      end
% end
% 
