function [prototypes bestw accerr]=llvqtrain(x,y,varargin)
% lerning LVQ together with linearization term 
% linearization is done by projection of LVQ/QPC prototypes on first
% QPC/PCA
% direction.
% Refer to "help llvqtrain_config" for more details.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

config = llvqtrain_config(varargin{:});
if config.display > 0 
    disp(config);
end

% LVQ parameters
lvqlr   = config.lvqlr;
initp   = config.initp;
maxlrate = config.maxlrate;

% linearization parameters
linear  = 1; if strcmp(config.linear,'no')==1; linear=0; end;
llrate  = config.llrate;
llupdate = config.llupdate;

eps = config.eps;
maxiterations = config.maxiterations;
%initiations = param.Results.initiations;
avgtest     = config.checkPeriod;

% % loging
% param.addParamValue('log','off',@(x)any(strcmpi(x,{'on','off'})));
% param.addParamValue('logFile',[],@ischar);
% param.addParamValue('dataName','data',@ischar);
% param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
% param.addParamValue('savedir',[],@ischar);
% param.addParamValue('display','short',@(x)any(strcmpi(x,{'none','all','short'})));
% 
% % plotting
% param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[nv nf]=size(x);
ci=classstat(y);

if isa(config.display,'char') == 1
    switch config.method
        case 'none'
            display = 0;
        case 'short'
            display = 1;
        case 'all';
            display = 2;
        otherwise
            display = 3;
    end
else
    display = config.display;
end

%method = 1;  % PCA
switch config.method
    case 'qpc';
%        method = 2;
        linearizator=@(px,py,w)linearization_qpc(x,y,px,py,w);
    case 'pca' 
%        method = 1;
        linearizator=@(px,py,w)linearization_pca(px);
end

if config.k < ci.labelsCount; config.k=ci.labelsCount; end
if config.k > nv; config.k = nv; end
if isempty(llupdate); llupdate = nv; end;

% prototypes initialization (number of prototypes balanced with respect to class distribution, random vector position)
if isempty(initp)
    prototypes = prototypes_init(x,y,config.k,'balanced');
else
    prototypes=initp;
end

k=size(prototypes,1);

if isempty(maxiterations); maxiterations = k*50; end;

lvqerr=zeros(1,maxiterations);

stop = 0;
ne=1;
%avgerr = 1;

px = prototypes(:,1:end-1);
py = prototypes(:,end);

wp = [];
if linear == 1
    if k > 1
        wp = linearizator(px,py,[]);
    else
       wp=rand(1,nf); wp=wp/norm(wp);
    end
end

distance=@(x,y)dEuclid(x,y);

lrate=ones(1,k)*lvqlr;
tun = zeros(1,k);
maxtun=10;

if linear == 0
    ilvqerr=lvqerror(x,y,[px py],distance);
else
    ilvqerr=lvqerror(x*wp',y,[px*wp' py],distance); %error after projection
end

if display > 1
    fprintf('ep   0 error %6.4f [ ',ilvqerr); fprintf('%3.2f ',wp); fprintf(']\n');
end


cfr = 1;

while stop == 0
    
    id = randperm(nv);
    for ni=1:nv     % number of iterations
        % LVQ1 
        [pid S]=lvq1([px py],x(id(ni),:),y(id(ni)),distance);
        
        lr=lrate(pid);
        px(pid,:)=px(pid,:)+cfr*S*lr*(x(id(ni),:)-px(pid,:));
        lrate(pid)=lr/(1+S*lr);
        if lrate(pid) > maxlrate; lrate(pid)=maxlrate; end

        if mod((ne-1)*nv+ni,llupdate) == 0 && linear == 1  % linearization 
            if k > 2
               [wp step]=linearizator(px,py,wp);
               px=px-llrate*step;
            end
                
            if k == 2
                wp=px(1,:)-px(2,:);
                wp=wp/norm(wp);
            end

            %   lvqerr4=lvqerror(x,y,[px py]);
            %   llvqerr4=lvqerror(x*wp',y,[px*wp' py]); %error after projection
            %     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f Elin %6.4f [ ',ne,lvqerr(ne),llvqerr,lerr);
           %     fprintf('After lin. ep %3d Elvq %6.4f Ellvq %6.4f [ ',ne,lvqerr4,llvqerr4);   fprintf('%3.2f ',wp);   fprintf(']\n');
        end
    end

    if linear == 0
         [error pn]=lvqerror(x,y,[px py],distance);
    else
         [error pn]=lvqerror(x*wp',y,[px*wp' py],distance); %error after projection
    end
    lvqerr(ne)=error;

    if display > 1
        fprintf('ep %3d error %6.4f [ ',ne,lvqerr(ne));   fprintf('%3.2f ',wp);   fprintf(']\n');
    end
%          clf;
%     bgraph3(x*wp',y);
%     bgraph3(px*wp',py,'select','yes');

    % what to do whith redundand prototypes ?
    switch config.dead
        case 'remove'
            deadp = pn(:,1)+pn(:,2) == 0;
            px=px(~deadp,:);
            py=py(~deadp);
            lrate=lrate(~deadp);
        case 'transfer'
             deadp = pn(:,1)+pn(:,2) == 0;
             if nnz(deadp) > 0
                 tunrem=tun>maxtun;
                 if nnz(tunrem) > 0 && nnz(tunrem) < size(px,1)
                     % usuwamy te ktore za duzo razy tunelowaly
%                     px=px(~tunrem,:);
%                     py=py(~tunrem);
%                     lrate=lrate(~tunrem);
%                     fprintf('Removing %d prototypes (tuneling to many times)\n',nnz(tunrem));
%                     deadp=deadp(~tunrem);
%                     tun=zeros(1,nnz(~tunrem));
%                     k=k-1;
                     fprintf('Warning: Dead prototypes removing not allowed\n');
                 end
                 
                 tun(deadp)=tun(deadp)+1;
                 px=trnsfer(x,y,[px py],deadp);
                 lrate(deadp)=lvqlr./tun(deadp);
                 if linear == 0
                     lvqerr2=lvqerror(x,y,[px py],distance);
                 else
                  lvqerr2=lvqerror(x*wp',y,[px*wp' py],distance); %error after projection
                 end
           %     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f Elin %6.4f [ ',ne,lvqerr(ne),llvqerr,lerr);
               if display > 1
                    fprintf('TUNELING\nep %3d error %6.4f\n ',ne,lvqerr2);
               end
            end
    end

    % plot(lvqerr);

%     clf;
%     scaterplot(x,y,1:3);
%     hold on;
%     scaterplot(px,py,1:3,'select','yes');
%     hold off;
%     clf;
%     bgraph3(x*wp',y);
%     bgraph3(px*wp',py,'select','yes');
%     drawnow;

%    if mod(ne,avgtest) == 0 
%         lastavgerr = avgerr;
    if ne >= avgtest
        lasterrtab=lvqerr(ne-avgtest+1:ne);
%         avgerr = mean(lasterrtab);
          
%        if (abs((avgerr - lastavgerr)/lastavgerr) < eps || std(lasterrtab))<eps && ne > 1  
        if std(lasterrtab)<eps 
           stop = 1;
            if display > 1
               fprintf('STOP: Error does not change to much\n');
            end
%            fprintf('ep %3d Elvq %6.4f Ellvq %6.4f lr %4.3f Elin %6.4f llr %4.3f [ ',ne,lvqerr(ne),llvqerr,lvqlr,lerr,llrate);
%            fprintf('%3.2f ',wp);
%            fprintf(']\n');
%            plot(lvqerr);
%            clf;
%            bgraph3([x ; prototypes(:,1:end-1)]*wp',[y ; ones(k,1)+3]);
%            drawnow;
        end;
    end;

    if ne>= maxiterations
        stop =1 ;
        if display > 1
            fprintf('STOP: Max Iterations (%d) reached\n',maxiterations);
        end
    end
    if norm(lrate) < eps 
        stop = 1;
        if display > 1
            fprintf('STOP: LVQ learning rate drops to much\n');
        end
    end
    ne=ne+1;
end
bestw=wp;
accerr=1-lvqerr(ne-1);
prototypes=[px py];


function newpx=trnsfer(x,y,p,dead)

nv=size(x,1);
%np=size(p,1);
distance=@(x,y)dEuclid(x,y);
%rest=nnz(dead);
didx=find(dead);

for di=didx'
    cc = p(di,end);
    id = randperm(nv);    
    for i=1:nv
        if y(id(i))== cc
            [I S]=lvq1(p,x(id(i),:),y(id(i)),distance);
            if S == -1
                p(di,1:end-1)=x(id(i),:);
                break;
            end
        end
    end
end
newpx=p(:,1:end-1);
