function parameters=llvqtrain_config(varargin)
% TODO - write help here

param = inputParser;
param.KeepUnmatched = true;
% data
% param.addRequired('x',@isnumeric);
% param.addRequired('y',@isnumeric);

% LVQ training
param.addOptional('k',0,@(x)isnumeric(x) );
param.addOptional('lvqlr',0.05,@(x)isnumeric(x) && x>0);
param.addOptional('initp',[],@(x)isnumeric(x));
param.addParamValue('maxlrate',0.5,@(x)numeric && x>0);
param.addParamValue('dead','transfer',@(x)any(strcmpi(x,{'leave','transfer','remove'})));

% linearization parameters
param.addParamValue('linear','yes',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('method','pca',@(x)any(strcmpi(x,{'pca','qpc'})));
param.addParamValue('llrate',0.01,@(x)isnumeric(x) && x>0);
param.addParamValue('llupdate',[],@(x)isnumeric(x));

param.addParamValue('eps',0.001,@(x)isnumeric(x) && x>0);
param.addParamValue('maxiterations',[],@(x)isnumeric(x));
param.addParamValue('initiations',5,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('checkPeriod',3,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
%param.addParamValue('stopCriterium',2,@(x)x==1|| x==2);

% loging
param.addParamValue('log','off',@(x)any(strcmpi(x,{'on','off'})));
param.addParamValue('logFile',[],@ischar);
param.addParamValue('dataName','data',@ischar);
param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
param.addParamValue('savedir',[],@ischar);
param.addParamValue('display',0,@(x)((isnumeric(x)&& x >= 0) || any(strcmpi(x,{'none','all','short'}))));

% plotting
param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));
%
param.parse(varargin{:});
%disp(param.Results);
unmatched = param.Unmatched;
unames=fieldnames(unmatched);

parameters = param.Results;
clear param;

if nargout  < 2 && size(unames,1) > 0
        error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
end
