function net=mlptrain_reg(x,y,n,lr,maxiter,eps)

% MLPTRAIN 
%     skrypt pomocniczy do tworzenia MLP (uzywa NNToolbox)

if nargin < 6; eps = 0.001 ; end
if nargin < 5; maxiter = 1000 ; end
if nargin < 4; lr = 0.1 ; end
if nargin < 3; n = 10; end

outputs = 1;
outputNode = 'purelin';
nodetype = 'logsig'; % logsig, tansig, purelin

if verLessThan('matlab', '7.5')
    if n == 0
        net1=newff(minmax(x'),outputs,{outputNode});
    else 
        net1=newff(minmax(x'),[n outputs],{nodetype outputNode});
    end
else
    net1=newff(x',y',{nodetype}); %% !!! to trzeba zmienic na kis
end

net.nodetype=nodetype;
net1.trainParam.show=NaN;
net1.trainParam.epochs=maxiter;
net1.trainParam.lr=lr;
net1.trainParam.goal=eps;
net.net=train(net1,x',y');
net.nw=n;
net.trainmse=mlptest_reg(x,y,net);