function [acc labels]=nettest(x,y,net)
% NETTEST(X,Y,NET) accuracy test on X dataset with labels Y for network NET
%    
%  ACC = NETTEST(X,Y,NET) returns ACCuracy value
%  [ACC LABELS]= NETTEST(X,Y,NET) returns predicted LABELS

vectorsCount = size(x,1);
 
neurons=size(net,2);
labels = zeros(vectorsCount,1);
theta = 0.5;
 
for k=neurons:-1:1
     ind = ones(vectorsCount,1);
     
     for i=1:net{k}.n
        proj = x*net{k}.w(i,:)';
        func = net{k}.func{i};
        ind = ind .* (func(proj) > theta);
     end
     labels(ind == 1) = net{k}.label; 
end
acc=100.0 *(1.0 - sum(labels ~= y)/vectorsCount);