function [bestw bestqpc bestproto]=qpctrain_simple(x,y,varargin)
% proste uczenie QPC, prototypy w centrach klas, uczenie QPC z protorypami
% Plik bazuje na qpctrain.m 

%function [bestw bestqpc qpctable]=qpctrain(x,y,varargin)
% QPCTRAIN runs optimalization proces of QPC index for given dataset X and labels Y.
%
%   W = QPCTRAIN(X,Y,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize QPC index value
%	X : dataset
%	Y : labels
%  
%   Run "help qpc_config" for details.
%
%	e.g.   w=qpctrain(x,y,'function','triangular','beta',3,'plot','qpc')
%		use triangular function with beta = 3 and plot change of qpc function douring learning (function width)
%
%

parameters = qpc_config(varargin{:});

disp(parameters);

directions  = parameters.directions;
%ortmethod   = param.Results.orthogonalizationMethod;

%fprintf('Input parameters:\n\n');
%disp(param.Results);
%disp(param.Parameters);

qpclearning=@(x,y,p)qpc_1d(x,y,p);

[vx fx]=size(x);

bestw = zeros(directions,fx);
bestqpc = zeros(directions,1);
bestprot = cell(directions,1);

if directions > fx; directions = fx ; end 

%xp=x;

x1=zeros(vx,directions);

parameters.initiations = 1;
acc1=zeros(directions,1);
acc=zeros(directions,1);

for dirCount = 1:directions
    logfilename = sprintf('%s.qpc_simple.%s.%0.1f',parameters.dataName,parameters.function,parameters.beta);

    if dirCount == 1
        P =  [];
        xp = x;
    else
        P=eye(fx)-bestw'*bestw;  % operator projekcji na podprz. otronormalna
        xp=x*P;        
    end
    parameters.logfilename=sprintf('%s.d%d',logfilename,dirCount);
%    [bw bqpc qpctable]=qpclearning(xp,y,parameters);

    parameters.prototypes = prototypes_init(xp,y);
    [bw bqpc param]=qpclearning(xp,y,parameters);
    
    px=param.prototypes(:,1:end-1);
    
    if dirCount > 1
        bw=bw*P;
        px=px*P;
    end
    bestproto{dirCount} = [px parameters.prototypes(:,end)];
    bestw(dirCount,:)=bw; %/norm(bw);
    bestqpc(dirCount)=bqpc;


    x1(:,dirCount)=x*bestw(dirCount,:)';
    pwx{dirCount} = bestproto{dirCount}(:,1:end-1)*bestw(dirCount,:)';
    acc(dirCount)=1-lvqerror(x1(:,1:dirCount),y,[[pwx{1:dirCount}] parameters.prototypes(:,end)]);
    acc1(dirCount)=1-lvqerror(x1(:,dirCount),y,[pwx{dirCount} parameters.prototypes(:,end)]);    
    
    if strcmp(parameters.save,'all') || strcmp(parameters.save,'last')
       
        clf;
        bgraph(x1(:,dirCount),y);
        hold on;
        bgraph(pwx{dirCount},bestproto{1}(:,end),'select','yes','borders','yes');
        saveplot(sprintf('%s.bgraph.d%d',logfilename,dirCount));
        
        for f=2:dirCount
            clf;
            scaterplot(x1,y,[f-1 dirCount]);
            scaterplot([pwx{:}],bestproto{1}(:,end),[f-1 dirCount],'select','yes','borders','yes');
            saveplot(sprintf('%s.scatterplot.d%d-%d',logfilename,f-1,dirCount));
        end
    end
end

if directions > 1 && (strcmp(parameters.save,'all') || strcmp(parameters.save,'last'))
    clf;
    scaterplot(x*bestw',y,1:directions);
    scaterplot([pwx{:}],bestproto{1}(:,end),1:directions,'select','yes','borders','yes');
    saveplot(sprintf('%s.scatterplot.all',logfilename));
    plik=fopen(sprintf('%s.weights.all.log',logfilename),'w');
    for i=1:directions
        
        fprintf(plik,sprintf('Direction %2d\n',i));
        fprintf(plik,sprintf('QPC=%6.4f\n',bestqpc(i)));
        fprintf(plik,sprintf('LVQ acc.=%6.4f\n',acc(i)));
        fprintf(plik,sprintf('LVQ 1D acc.=%6.4f\n',acc1(i)));
        fprintf(plik,strcat('w=',sprintf(' %6.4f',bestw(i,:))));
        fprintf(plik,'\nPrototypes\n');
        
        for j=1:size(bestproto{i},1)
            fprintf(plik, '%6.4f ',bestproto{i}(j,1:end-1));
            fprintf(plik, '%d',bestproto{i}(j,end));
            fprintf(plik,'\n');
        end
        fprintf(plik,'\n');
    end
    fclose(plik);
    
end


function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);
% % octave only
% %	print('-dpng','-S640,480',name);


%    name = strcat(prefix,'.eps');
%  	 print('-depsc',name);

