%  skrypt generujacy wykresy (ICANN 08)
%  Dane : Parity10, Wine, circ4n2, Monk's 1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear;
load icann08data.mat

w=wp1;
x=normalize(par10(:,1:end-1));
y=par10(:,end);
figure(1);
ppigraph(x,y,w,'center',1);
figure(2);
[ppi dpii projection G]=ppifunction(x,y,w);
[gmax igmax] = max(G,[],2);
[pc node ic cl] = clusteroptimize2(x,y,w,'indGmax',igmax,'plot','all','beta',3);
figure(3);
bgraph3(x*node.w',y,'borders',[node.a node.b])




return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = -5:.1:5;

f=@(x,b)exp(-x.*x/b); %./sqrt(2*pi*b)
plot(x,f(x,1),x,f(x,2),x,f(x,5),'LineWidth',2);
legend('b = 1','b = 2','b = 5');
print('-depsc','fgauss.eps');

return;

f=@(x,b)f_triangular(x,b);
plot(x,f(x,1),x,f(x,2),x,f(x,5),'LineWidth',2);
legend('b = 1','b = 2','b = 5');
print('-depsc','ftriangular.eps');

f=@(x,b)f_x4(x,b);
plot(x,f(x,1),x,f(x,2),x,f(x,10),'LineWidth',2);
legend('b = 1','b = 2','b = 10');
print('-depsc','fx4.eps');

f=@(x,b)f_bisigm(x,-b,b,2);
plot(x,f(x,1),x,f(x,2),x,f(x,3),'LineWidth',2);
legend('b = 1','b = 2','b = 3');
print('-depsc','fbisigm.eps');

f=@(x,b)f_bicentral(x,b,0,2);
plot(x,f(x,1),x,f(x,2),x,f(x,3),'LineWidth',2);
legend('b = 1','b = 2','b = 3');
print('-depsc','fbicentral.eps');


return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear;
load icann08data.mat



color='yes';

% parity
figure(1); clf;
title='Parity 10';
labels={'Class 1','Class 2'};
sigma=0.005;
w1=wp1;
w2=wp2;
i1=ip1;
i2=ip2;
data=normalize(par10);
labelsalign='center'; % 'right' 
stralign='left';  % or 'right'
filename='par10-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*wp1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));


figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('I =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));

% Wine
figure(1); clf;
title='Wine';
labels={'Class 1','Class 2','Class 3'};
sigma=0.01;
w1=ww1;
w2=ww2;
i1=iw1;
i2=iw2;
data=normalize(wine);
labelsalign='center'; % 'right' 
stralign='left';  % or 'right'
filename='wine-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));


% Circ4n2
figure(1);
clf;
title='Concentric Rings';
labels={'Class 1','Class 2','Class 3','Class 4'};
sigma=0.01;
w1=wc1;
w2=wc2;
i1=ic1;
i2=ic2;
data=normalize(circ4n2);
labelsalign='right';
stralign='right';
filename='circ4n2-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));

% Monks1
figure(1); clf;
title='Monks 1';
labels={'Not a Monk','Is a Monk'};
sigma=0.01;
w1=wm1;
w2=wm2;
i1=im1;
i2=im2;
data=normalize(monks1);
labelsalign='center';
stralign='right';
filename='monks-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));
