function icann09plot

figure(1);
title='Austrailian';
labels={'Class 1','Class 2'};
sigma=0.05;
data=load('data/australian-statlog.dat');
[x y]=datap(data);
t=[ 1.422 0;  -1.050 1];
w=[-0.031 -0.073 -0.087 -0.091 -0.240 -0.135 -0.089 -0.795 -0.505 -0.068 -0.035 -0.038  0.013 -0.019];
name='australian';
plotresult(normalize(x),y,w,t,name,labels,title,sigma);
w1=[0     0     0     0     0     0     0     1     0     0     0     0     0     0];
name='australian-a8';
figure(5);
sigma=0.01;
bgraph3(x*w1',y,'color','yes','sigma',sigma,'labels',labels,'title',title);
print('-depsc',sprintf('%s-col.eps',name));

return;

figure(2);
data=load('data/bitsymetry20x100.dat');
title='Mirror Symmetry';
labels={'Not Symmetric','Symmetric'};
sigma=0.05;
[x y]=datap(data);
t=[ -0.882 0; 0.385 0;  0.136 1];
w=[-0.026  0.252  0.122 -0.037 -0.074 -0.335  0.255 -0.279  0.145 -0.394  0.398 -0.174  0.279 -0.192  0.335  0.107  0.087 -0.057 -0.204  0.059];
name='bitsymmetry';
plotresult(normalize(x),y,w,t,name,labels,title,sigma);
% 
figure(3);
title='Parity 10';
data=load('data/parity-10.set');
[x y]=datap(data);
sigma=0.01;
labels={'Class 1','Class 2'};
t=[-0.642 0;  0.637 0;  -2.175 0;  -0.011 1;  -1.224 1;  1.256 1;  1.822 0];
w=[ 0.327  0.295 -0.325 -0.322  0.315 -0.319  0.321  0.309 -0.319 -0.309];
name='parity10';
plotresult(normalize(x),y,w,t,name,labels,title,sigma);

w2=ones(1,10);
name='parity10-diag';
sigma=0.02;
figure(6);
bgraph3(x*w2',y,'color','yes','sigma',sigma,'labels',labels,'title',title);
print('-depsc',sprintf('%s-col.eps',name));

return ;


figure(4);
data=load('data/wine.dat');
[x y]=datap(data);
title='Wine';
labels={'Class 1','Class 2','Class 3'};
t=[-0.526 0.471 1;  0.245 -0.533 2;  0.996 0.055 3];
w=[ -0.147  0.075 -0.127  0.250 -0.030  0.151 -0.734 -0.073  0.035  0.274 -0.085 -0.322 -0.372;  0.393  0.077  0.403 -0.303  0.003  0.287 -0.393 -0.144 -0.089  0.187 -0.106  0.089  0.516];
name='wine';
plotresult(normalize(x),y,w,t,name,labels,title);

return;


function plotresult(x,y,w,p,prefix,labels,title,sigma)

col='yes';

wn=size(w,1);
if wn == 1
        clf;
         
         bgraph3(x*w',y,'color',col,'sigma',sigma,'labels',labels,'title',title);
         hold on;
         bgraph3(p(:,1:end-1),p(:,end),'select','yes','borders','yes','color',col);% ,'borders','yes');         
         print('-dpng','-r96',sprintf('%s.bgraph.png',prefix));
else
         clf;
         scaterplot(x*w',y,1:wn,'color',col,'featurename',{'w_1','w_2'},'title',title,'labels',labels);
         hold on;
         scaterplot(p(:,1:end-1),p(:,end),1:wn,'select','yes','borders','yes','color',col,'featurename',{'w_1','w_2'});         
         print('-dpng','-r96',sprintf('%s.all.scatter.png',prefix));
end
print('-depsc',sprintf('%s-col.eps',prefix));
return;

