function ah=bgraph(x,y,varargin)
% BGRAPH class distribution plot
%
% (bgraph uzywajacy ksdensity zamiast recznego wyznaczania gestosci)
% BGRAPH(X,Y) plots estimated distribution of X with respect to class labels Y.  
%
% BGRAPH(X,Y,SIGMA) value of SIGMA controls wildenes of gaussian functions used to estimate X
%    distribution. If not set then value of SIGMA is automatic choosen.
%
% BGRAPH(X,Y,OPTIONS)
%  Plot options:
%      'points'              : 'yes' or 'no', draw class-points at the bottom (default 'yes')
%      'color'               : 'yes' or 'no'
%      'position'            : [rectangle] look for PLOT options (default [0.1 0.1 .8 .8])
%
%  Text options:
%      'labels'              : 'on', 'off' or cell array of strings denoting class labels (default 'off')
%      'labelsalign'         : 'center' or 'right' 
%      'str'                 : cell array of strings (default '')
%      'stralign'            : 'left' or 'right', align of displayed strings   (default 'left')
%      'title'               : plot title
%      'xlabel'              : xlabel
%      'weights'             : table [1xN] od weights value displayed as a bar graph (default []) 
%
%  Density estimator options:
%      'sigma' or 'width'    : value of width for density estimator (see ksestimate)
%
%  Special options:
%      'select'              ; 'yes' or 'no', select prototypes on existing (!!!) bgraph plot, 
%                              note that this add some info on existing active plot
%      'function'            : handle to a function F(X) (e.g. @f_x4(X)) (default none)
%      'borders'  : cut points (default []), if 'select' = 'yes' then
%                  option 'yes' or 'auto' might be used for automatic borders
%                  drawning
%
% H = BGRAPH(X,Y,OPTIONS) returns 1x2 table with handles to axes of
% created figure.

%   TODO
%   * find smarter and faster way for automatic estimating sigma value 
%   * selected - how to make it simpler


parameters=bgraph_config(varargin{:});

pos = parameters.position;
func = parameters.function;
borders = parameters.borders;

pointsView = 1;
if strcmp(parameters.points,'no')
    pointsView = 0;
end
select = 0;
if strcmp(parameters.select,'yes')
    select = 1;
end

%w = pos(3);
margin = 0.1;

if nargin<2 || isempty(y)
    y=ones(size(x,1),2);
end    
data = [x y];
cstat = classstat(y);

showlabels = 0;
labelsc = cell(cstat.labelsCount,1);
for i=1:cstat.labelsCount
     labelsc{i} = num2str(cstat.labels(i));
end
if isa(parameters.labels,'cell')
    labelsc = parameters.labels;
    showlabels = 1;
end

if isa(parameters.labels,'char') && strcmp(parameters.labels,'on')
    showlabels = 1;
end

mind=min(data(:,1))-0.1;
maxd=max(data(:,1))+0.1;

colororder=[1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0.1 0.1 0.1];
mtype=['o','s','+','d','v','^'];
fig=gcf();

abot = [];
%atop = []; %  get(fig,'currentaxes')

msize = 2;
psize = 3;

linestyletop = '-';
linestylebot = 'o';

if strcmp(parameters.color,'no') == 1
    msize = 1;
    psize = 2;
    colororder = [0 0 0];
    linestyletop = '-|--|-.|:';
    linestylebot = 'o|s|+|d|v|^';
end
pxc=cell(1,1);

if select == 0
    delta=(maxd-mind)/100;
    xx=mind:delta:maxd;			% linear space

%    pxc=zeros(1,2*cstat.labelsCount);
    pxp=cell(1,2*cstat.labelsCount);

    pmax = zeros(1,cstat.labelsCount);
    
    for i=1:cstat.labelsCount
        nc1 = cstat.labelsPerClassCount(i);
        xc1 = data(cstat.labelsIndex{i},1);
 
        [f1,x1]=ksdensity(xc1,'width',parameters.sigma);
        pxc{2*i-1}= x1;
        pxc{2*i}=f1;
    %    [a pmax(i)]=max(pxc(i,:));
        [~, pmax(i)]=max(f1);
        pxp{2*i-1}=xc1;
        pxp{2*i}=(ones(1,nc1)*i);
    %    ticks(labelsPerClassCount-i+1)=pxp{2*i}(1);
    end        
    %clf;   %   plotting
    
    set(fig,'Renderer','painters');
    set(fig,'color','w','DefaultAxesColorOrder',colororder);
    %set(fig,'color','w','DefaultAxesLineStyleOrder','--|-.');
 	atop=axes();
	hold(atop,'on');

    hbot = 0;
    
    if pointsView == 1
        
        hbot = pos(4)/10;
        
        abot=axes('position',[pos(1) pos(2)             pos(3) hbot]);
        hold(abot,'on');
        set(abot,'Tag','abot');
%        [mind maxd]
%        [1 cstat.labelsCount]
        set(abot,'xlim',[mind maxd],'ylim',[1-0.1 cstat.labelsCount]);
        set(abot,'visible','off');
        set(abot,'ytick',[],'ycolor','w');
        set(abot,'YLim',[-.1 1.1]);
        set(abot,'ColorOrder',colororder,'LineStyleOrder',linestylebot);
    end

    htop = pos(4) - margin - hbot;
 
    set(atop,'xlim',[mind maxd]);
    set(atop,'Tag','atop');
    set(atop,'ytick',[],'ycolor','w');
    set(atop,'ColorOrder',colororder,'LineStyleOrder',linestyletop);
    set(atop,'position',[pos(1) pos(2)+margin+hbot pos(3) htop]);
    set(get(atop,'YLabel'),'String',parameters.ylabel,'Color','k')
    set(get(atop,'XLabel'),'String',parameters.xlabel,'Color','k')

%    set(gcf(),'currentaxes',atop);

    axes(atop);
    plot(pxc{:},'LineWidth',msize,'MarkerSize',psize); 
    drawnow;
    %text(atop,0.01,0.95,parameters.str,'units','normalized');
    %text(0.01,0.95,parameters.str,'units','normalized');
    %pos=[-0.12 1.3];
    if strcmp(parameters.stralign,'left')
        pos=[0 1];
        text(pos(1),pos(2),parameters.str,'units','normalized','HorizontalAlignment','left','visible','on');
    else
        pos=[1 1];
        text(pos(1),pos(2),parameters.str,'units','normalized','HorizontalAlignment','right','visible','on');
    end
    if ~strcmp(parameters.title,'')
         title(parameters.title);
    end

    
    
    mm=get(gca,'YLim');
    % if ~isempty(center)
    %     plot([projection(igmax) projection(igmax)],[mm(1) G(igmax)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
    % end

     if isa(borders,'numeric') && ~isempty(borders)
         for b=borders
            set(gca,'Color','none');
            plot([ b b],[mm(1) mm(2)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 

         end
     end

    if pointsView == 1
        axes(abot);
        %xlabel(parameters.str{1})
        
        plot(pxp{:},'MarkerSize',psize,'LineWidth',msize); 
        ylim('auto');


        if ~isempty(func)
            axes(abot);
        %    area('v6',xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
            area(xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
        end

        %plot(pxp{:},'MarkerSize',psize,'MarkerFaceColor',[.7 .7 .7]); 
        %plot(xx,pxc1,strcat('o',colors(i)),'markersize',3,'MarkerFaceColor',colors(i)); 

        if showlabels == 1
            axes(abot);
            for i=1:cstat.labelsCount
                if strcmp(parameters.labelsalign,'center')
                    text(xx(pmax(i)),pxp{2*i}(1)+0.1,labelsc{i},'HorizontalAlignment','center','VerticalAlignment','bottom','margin',100);
                end
                if strcmp(parameters.labelsalign,'right')
                    text(max(pxp{2*i-1}+0.05),pxp{2*i}(1),labelsc{i},'HorizontalAlignment','left','VerticalAlignment','middle','margin',100);
                end
            end
        end
        if strcmp(parameters.legend,'yes')
            axes(atop)
            legend(labelsc,'location','northeast');
         %   legend('boxoff');
        end
        
    end
else
    %ah=get(fig,'Children');
    atop=findobj('Tag','atop');
    abot=findobj('Tag','abot');
    axes(abot);
    hold on;
    pv=size(x,1);
    for pr=1:pv
        y1= y(pr)==cstat.labels;
        kolor = colororder(y1,:);
        
        if strcmp(parameters.color,'yes') == 1
            plot(abot,x(pr),find(y1),'o','MarkerFaceColor',kolor,'MarkerEdgeColor','k','LineWidth',2,'MarkerSize',7);
        else
            plot(abot,x(pr),find(y1),mtype(y1),'MarkerSize',8,'LineWidth',3);
        end


    end

    if isa(borders,'char') && (strcmp(parameters.borders,'yes') || strcmp(parameters.borders,'auto'))
        [sx ti] = sort(x);
        sy=y(ti);
        xn=length(x);
        for bi=1:xn-1
            if sy(bi) ~= sy(bi+1)
                t=(sx(bi)+sx(bi+1))/2;
%                 axes(abot);
%                 yl1 = get(gca,'YLim');
%                 plot([t t],yl1,'-k');
             %   axes(atop);
               set(atop,'NextPlot','add','Color','none');
                yl1 = get(atop,'YLim'); yl1(2) = yl1(2)*0.9;
                plot(atop,[t t],yl1,'-','Color',[0.6 0.6 0.6]);

            end
        end
        
    end
%             if borders == 1 && pr == 2
%                 w = x(2,[f1 f2])-x(1,[f1 f2]);
%                 w=w/norm(w);
%                 t= 0.5*(x(1,[f1 f2])+x(2,[f1 f2]));
%                 b=-t*w';
%                  y1=-(b+w(1)*xlim(1))/w(2);
%                  y2=-(b+w(1)*xlim(2))/w(2);
% %                y1=-(b+w(1)*(-300))/w(2);
% %                y2=-(b+w(1)*50)/w(2);
%                 plot(ax,xlim,[y1 y2],'-k');
%             end

end

if ~isempty(parameters.weights)
    nw = size(parameters.weights,2);
    wh = 0.02*nw;
    if wh > 0.9 
        wh = 0.9;
    end
     abar=axes('position',[.05  .85  wh  .1],...
         'XAxisLocation','top',...
         'Color','none',...
         'xlim',[1 nw],...
         'ylim',[-1 +1],...
         'xtick',[1 nw],...
         'XColor','w',...
         'YColor','w',...
         'box','on','Tag','bar');
     hold(abar,'on');
  
     bh=bar(1:nw,parameters.weights,0.8);
     set(get(bh,'BaseLine'),'LineWidth',1,'LineStyle','-','Color',[0.8 0.8 0.8]);
  %   xlim=get(abar,'Xlim');
     text(1,1,sprintf('Nmber of features %d',nw));
     
     hold(abar,'off');
    
end


if pointsView == 1 
    ah = [atop ; abot];
    hold(abot,'off')
else
    ah = atop;
end
hold(atop,'off');

return 

function parameters=bgraph_config(varargin)
    param = inputParser;

%     param.addRequired('x',@isnumeric);
%     param.addRequired('y',@isnumeric);
    param.addOptional('sigma',[],@(x)isnumeric(x) && x>0);
    %param.addParamValue('position',[0.05 0.05 .9 .9],@(x)isnumeric(x) && size(x,2) == 4 );
    param.addParamValue('position',[0.1 0.1 .8 .8],@(x)isnumeric(x) && size(x,2) == 4 );
    param.addParamValue('function',[],@(x)isa(x,'function_handle'));
    param.addParamValue('weights',[],@(x)isnumeric(x));
    param.addParamValue('color','yes',@(x)any(strcmpi(x,{'yes','no'})));
    param.addParamValue('labels','off');
    param.addParamValue('labelsalign','center',@(x)any(strcmpi(x,{'center','right'})));
    param.addParamValue('title','');
    param.addParamValue('ylabel','');
    param.addParamValue('str','');
    param.addParamValue('xlabel','');
    param.addParamValue('stralign','left',@(x)any(strcmpi(x,{'left','right'})));
    %param.addParamValue('center',[]);
    %param.addParamValue('borders',[]);
    param.addParamValue('select','no',@(x)any(strcmpi(x,{'yes','no'})));
    param.addParamValue('legend','no',@(x)any(strcmpi(x,{'yes','no'})));
    param.addParamValue('borders',[]);
    param.addParamValue('points','yes',@(x)any(strcmpi(x,{'yes','no'})));  % show bottom plot with points

    param.parse(varargin{:});
    
    parameters=param.Results;
    clear param;
    return;

