function [bestw bestppi]=ppi2woptimize(x,y,varargin)
% PPOPTIMIZE runs optimalization proces of PPI funcrion for given dataset X and class labels Y.
%
%   W = PPOPTIMIZE4(X,Y,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize pp index value
%	X : dataset
%	Y : labels
%
%	posible PARAMETERS are:
%	
%		'function' - value 'triangle','f_x4' or 'bicentral' are recognized
%		           as f_triangular, f_x4 and f_bicentral function accordinly (default f_x4)
%                  
%		'beta'     - value of BETA parameter - width of given function
%		           (default 10, good value for normalized data and f_x4 function)
%
%		'eps'	   - set eps value (default 0.001), for given stoping
%		           criterium define max. difference between values of (or average values over checkPeriod) PPIFUNCTION
%
%     Optimalization:
%		'maxIterations'	  - maximum number of iterations (default 1000)
%       'initiations'     - number of repetitions of optimalization, best
%                       solusion over those initiolization is choosen for final W.
%		'learningRate'    - learning rate for gradnient descent procedure
%		(default 0.1)
%		'initWeights'     - initial weights (staring point)
%       'stopCriterium'   - choose criterium for ending of optimalization, currently implemented values are:
%                         1 - check difference beetwen two last values  
%                         2 (default) check difference beetwen average
%                         values over 'checkPeriod' last values
%       'checkPeriod'     - if 'stopCriterium' == 2 then optimalization
%                         stops when average value of qpcfunction over checkPeriod last
%                         values is considered. If difference beetwen two last average values
%                         is less (default: 5)
%       
%     Searching of ortogonal solusion:
%        'ortoWeights'    - weights table for witch ortgonal solution will
%        be searched  
%        'lambda'         - value of LAMBDA parameter defines influence of
%        ortogonalization process if ORTOWEIHHTS are given.
%
%     Other optimalization parameters;
%        'iGmax'          - index of input vector for with maximum value of G
%                         function will be searched, required in secound
%                         stage of learning (current not working)
%
%     Plotting:
%		 'plot'           - currently implemented plots: (default 'none') 
%                        'all' - plots all on single figure for each iteration, 
%                        'ppi' - plots PPIFUNCTION for each iteration,
%                        'last' - plots final projection 
%      
%     Results saving:
%        'savedir'        - name of directory to store logfiles and
%                         pictures created douring learning process.
%                         Default dir name is: ppi-results-yyyy.mm.dd,
%                         where yyyy.mm.dd is the current date.
%        'save'        -  'all', 'last' - saves  pictures in SAVEDIR with
%                          apropriate names (default 'none')
%                         directory. Requred for animations but disk space
%                         consuming. Note thet if SAVEOALL = YES then 
%                         option PLOT is automatic set to ALL.
%        'logFile'        - name of file with stored results (default: data.log if no dataname is given)
%        'dataName'       - name of data used in names of output files
%                         (logs and pictures), (default: data)

param = inputParser;
% data
param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);

% inner function
param.addOptional('function','f_x4',@(x)any(strcmpi(x,{'triangle','f_x4','fx4','bicentral'})));
param.addOptional('beta',10, @(x)isnumeric(x) && x>0);

% optimalization global
param.addParamValue('learningRate',0.1,@(x)isnumeric(x) && x >= 0);
param.addParamValue('eps',0.001,@(x)isnumeric(x) && x>0);
param.addParamValue('maxIterations',1000,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('initiations',5,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('checkPeriod',5,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('stopCriterium',2,@(x)x==1|| x==2);

% optimalization - case depend
param.addParamValue('initWeights', [],@(x)isnumeric(x));
param.addParamValue('lambda', 0.1,@(x)isnumeric(x) && x > 0 );
param.addParamValue('ortoWeights',[],@isnumeric);
param.addParamValue('indGmax',[],@isnumeric);

% loging
param.addParamValue('logFile',[],@ischar);
param.addParamValue('dataName','data',@ischar);
param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
param.addParamValue('savedir',[],@ischar);

% plotting
param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));

param.parse(x,y,varargin{:});

parameters = param.Results;
clear param;

% fprintf('Input parameters:\n\n');
% disp(param.Results);
%disp(param.Parameters);

[vx fx]=size(x);

beta        = parameters.beta;
lrate       = parameters.learningRate;	% learning rate (step of gradnient descent)
eps         = parameters.eps;	% 
nmax        = parameters.maxIterations;     % nax. number of iterations
%pplot       = 0;
%lastppi     = -1;
plotall     = 0;
plotlast    = 0;
iplot       = 0;
% ffplot      = 0;
ninit       = parameters.initiations;
ww          = parameters.initWeights;
dataname    = parameters.dataName;
avgtest     = parameters.checkPeriod;
stopcriterium = parameters.stopCriterium;
% iGmax       = parameters.indGmax;
%wort        = parameters.ortoWeights;
lambda      = parameters.lambda;
%orto        = ~isempty(wort);
funcname    = parameters.function;
%wo          = 0;
saveall     = 0;
savelast    = 0;
savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));



bestw = [];
bestppi = [];
bestinit = 0;
bestn = 0;
% bestigmax = -1;

switch funcname
    case { 'fx4' , 'f_x4'}
        func = @(xx)f_x4(xx,beta);
    case 'triangle'
        func = @(xx)f_triangular(xx,beta);
    case 'bicentral'
        func = @(xx)f_bicentral(xx,beta,0,10);
    otherwise
        error('Ten blad nie powinien wystapic - ale jesli wystapil to znaczy, ze jest cos nie tak z podana funkcja');
end

switch parameters.plot
    case 'all'
        plotall = 1;
    case 'ppi'
        iplot = 1;
    case 'last'
        plotlast = 1;
end

if ~isempty(parameters.savedir)
    savedir = parameters.savedir;
end

switch parameters.save
    case 'all'
        plotall = 1;
        saveall = 1;
    case 'last'
        plotlast = 1;
        savelast = 1;
    case 'iplot'
        iplot = 1;
end


[s comment]=mkdir(savedir);
if s == 0
    error(comment);
end

procedure   = strcat('ppi-2w',sprintf('.%0.1f',lambda));
prefix = strcat(savedir,'/',dataname,sprintf('.%s-%s.%0.1f',procedure,funcname,beta));
logfilename = parameters.logFile;
if isempty(logfilename)
    logfilename = strcat(prefix,'.log');
end
logfile = fopen(logfilename,'wt');

ppifun = @(wx)ppi2wfunction2(x,y,wx,lambda,func);



%%%%%%%%%%%%%%   OK - tu zaczyna sie zabawa %%

for initcount=1:ninit
	fprintf(logfile,'Statring\nInitialization %d of %d\n',initcount,ninit);
	fprintf(logfile,'dataname      = %s\n',dataname);
	fprintf('dataname      = %s\n',dataname);
    fprintf(logfile,'vectors       = %d\n',vx);
	fprintf(logfile,'features      = %d\n',fx);
	fprintf(logfile,'learningRate  = %f\n',lrate);
	fprintf(logfile,'eps           = %f\n',eps);
	fprintf(logfile,'maxIterations = %d\n',nmax);
	fprintf(logfile,'function      = %s\n',func2str(func));
	fprintf(logfile,'beta          = %f\n',beta);
	fprintf(logfile,'initiations   = %f\n',ninit);
	fprintf(logfile,'lambda        = %f\n',lambda);
    
	fprintf('Statring\nInitiatlization %d of %d\n',initcount,ninit);
	
    if isempty(ww)
        w = rand(1,2*fx)*2-1;   
        % random initialization [-1,1]
    else
		w = ww;
    end
    
    
	%w0 = w;
	n = 0;
	ppitable = zeros(1,nmax+1);
	fprintf('N   PPIndex     weights');      fprintf('\n');
% 	
%    fprintf('%d  %6.4f    ',n,ppi); fprintf('  %6.4f',w); fprintf('\n');
	fprintf(logfile,'N   PPIndex     weights\n');
% 	fprintf(logfile,'%d  %10.6f    ',n,ppi); fprintf(logfile,'  %6.4f',w); fprintf(logfile,'\n');
	
    avgppi = 0;
    lastavgppi = 0;
    
    
    while ( n < nmax )
        if (mod(n,avgtest) == 0 && n > 0)
            lastavgppi = avgppi;
            avgppi = mean(ppitable(n-avgtest+1:n));
        end;

        w1 = w(1:fx);
        w2 = w(fx+1:end);

        w1=w1/norm(w1);
        w2=w2/norm(w2);
        w = [w1 w2];
        [ppi ppid ] = ppifun(w);
		
%         if nargout > 2
%             [gmax igmax] = max(G);
%         end
%         
        lastppi = ppi;
		ppitable(1,n+1) = ppi;
	
        if iplot == 1 && n > 0
			plotppi(ppitable,avgtest);
        end

       wo = w1*w2';

        if plotall == 1
            str=cell(1,3);
            str{2} = strcat('\alpha = ',sprintf(' %.4f ',wo));
            str{1} = strcat('I = ',sprintf(' %.4f ',ppitable(n+1)));
            str{3} = strcat('N = ',sprintf(' %d ',n));
            clf;
            set(gcf,'Color','w');
            scaterplot([x*w2' x*w1'],y);
            set(gca,'position',[0.1 0.45 0.85 0.50]);
 
            xlabel('w2 = ');
            ylabel('w1 = ');

%            xlabel(strcat('w2 = ',sprintf(' %.2f ',w2)));
%            ylabel(strcat('w1 = ',sprintf(' %.2f ',w1)));
            text(0.02,0.85,str,'units','normalized');
            
            ah(3) = axes('position',[0.1 0.1 0.85 0.25]);
            plotppi(ppitable,n,50);
            drawnow();
            
           if saveall == 1
                saveplot(strcat(prefix,sprintf('-%d.frame%04d',initcount,n)));
            end
        end;
        
        
		fprintf('%3d  %10.6f   ',n,ppi); 
        fprintf(logfile,'%d  %10.6f    ',n,ppi); 
        fprintf('  %6.4f',w); 
        fprintf(logfile,'  %6.4f',w); 
        fprintf('  [ %6.4f ] ',wo);
        fprintf(logfile,'  [ %6.4f ] ',wo);
        fprintf('\n');
		fprintf(logfile,'\n');

        if (stopcriterium == 1 && (abs((ppi - lastppi)/lastppi) < eps) && n > 1 ) 
            break;
        end;
        if (stopcriterium == 2 && abs((avgppi - lastavgppi)/lastavgppi) < eps && n > 1 ) 
            break;
        end;
   
        
        w = w + lrate * ppid;
        n = n + 1;
    end;
	
	if plotlast == 1
            str=cell(1,3);
            str{2} = strcat('\alpha = ',sprintf(' %.4f ',wo));
            str{1} = strcat('I = ',sprintf(' %.4f ',ppitable(n+1)));
            str{3} = strcat('N = ',sprintf(' %d ',n));
            clf;
            set(gcf,'Color','w');
            ah = scaterplot([x*w2' x*w1'],y);
            set(gca,'position',[0.1 0.45 0.85 0.50]);
            
                xlabel('w2 = ');
                ylabel('w1 = ');

%            xlabel(strcat('w2 = ',sprintf(' %.2f ',w2)));
%            ylabel(strcat('w1 = ',sprintf(' %.2f ',w1)));
            text(0.02,0.85,str,'units','normalized');
            
            ah(3) = axes('position',[0.1 0.1 0.85 0.25]);
            plotppi(ppitable,n,50);
            drawnow();
        if savelast == 1
            saveplot(strcat(prefix,sprintf('-%d.last',initcount)));
        end
	end;
	
	fprintf(logfile,'---------------------------------------------\n\n');
	if (initcount == 1) || (ppi > bestppi) 
		bestw = w;
		bestppi = ppi;
		bestinit = initcount;
		bestn = n;
	end
end

fprintf('Initialization  %d was the best\n',bestinit);
fprintf(logfile,'Initialization  %d was the best\n',bestinit);
fprintf('%d  %6.4f    ',bestn,bestppi); fprintf('  %6.4f',bestw); fprintf('\n');
fprintf(logfile,'%d  %6.4f    ',bestn,bestppi); fprintf(logfile,'  %6.4f',bestw); fprintf(logfile,'\n');


fclose(logfile);



% function fplotall2(func,beta,prefix,n)
% 	ax=get(gcf(),'children');
%     axc=ax(2);
% 	axes(axc);
% 	xx=get(axc,'xlim');
% 	yy=get(axc,'ylim');
% 	dx=(xx(2)-xx(1))/100;
% 	xx1=xx(1):dx:xx(2);
% 	yy1=yy(2)*func(xx1,beta,(xx(2)+xx(1))/2);
%     
%     %area(xx1,yy1,'edgecolor','w','facecolor','y');
%     % !! funkcja AREA zwraca blad w mojej wersji MATLABa - dlatego uzywam
%     % tu funkcji PLOT
% 
%     plot(xx1,yy1,'-','MarkerSize',1);
%     
%     gc=get(axc,'children');
% 	set(axc,'children',gc(end:-1:1));
	
%	name = strcat(prefix,sprintf('%04d.png',n));

%	print('-dpng','-r96',name);
% octave only
%	print('-dpng','-S640,480',name);
%	name = strcat(prefix,sprintf('%04d.eps',n));
%	print('-depsc',name);

function plotppi(ppitable,n,scalefactor)
    if nargin < 3
        scalefactor = 10;
    end
    if nargin < 2
        n = length(ppitable);
    end
    xl = scalefactor.*(fix(n./scalefactor)+1);
    cla;
    hold on;
    xlim([0 xl]);
    xlabel('Iterations');
    ylabel('PPI value');
    plot(0:n,ppitable(1:n+1),'-b','LineWidth',2);
    box on;
 	hold off;
    
function saveplot(prefix)


 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);
% % octave only
% %	print('-dpng','-S640,480',name);
% 	name = strcat(prefix,'.eps');
% 	print('-depsc',name);

