function p=project_points(t,w,m)
% FUNCTIION  P=PROJECT_POINT(T,W,M)
% If T denotes points projected on W and M is some point on line Y=WX+M 
% in original space, eq. middle point  M=mean(T) or M=mean(X) then
% function computes positions of points in original space placed along the
% line.
% Let T = P*W'/norm(W)         P points projedted on direction P.
% Then P(i,;) = (T(i,:) - M*W')*W + M 


n=size(t,1);
wn=w/norm(w);
p= t*wn + ones(n,1)*(m- m*wn'*wn);
