%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [bestw bestqpc parameters]=qpc_1d(x,y,parameters)
%function [bestw bestqpc qpctable bestigmax]=qpc_1d(x,y,parameters)
% One direction search
% function [bestw bestqpc qpctable bestigmax]=qpc_1d(x,y,parameters)
%
% Use QPCTRAIN to learn QPC index
%
%

% TODO:
%  - poprawic wyswietlanie i zapisywanie log-ow (po wprowadzeniu Matlabowych metod optymalizacji nalezaloby to ujednolicic)
%  - poprawic przepisywanie opcji (ujednolicic opcje z metodami
%  matlabowymi)q
% * uczenie prototypow na razie dziala tylko w trybie uczenie pojedynczego
% kierunku (bez multistartu)

[vx fx]=size(x);
if ~isempty(y)
    ci=classstat(y); %class info
else
    ci = [];
end

beta        = parameters.beta;           
lrate       = parameters.learningRate;	% learning rate (step of gradnient descent)
eps         = parameters.eps;	% 
nmax        = parameters.maxIterations;     % nax. number of iterations
killPeriod  = parameters.killPeriod;
leaven      = 3;
%pplot       = 0;
%lastqpc     = -1;
plotall     = 0;
plotlast    = 0;
iplot       = 0;
% ffplot      = 0;

plr          = parameters.plr;
% ninit       = parameters.initiations;
dataname    = parameters.dataName;
avgtest     = parameters.checkPeriod;
stopcriterium = parameters.stopCriterium;
iGmax       = parameters.indGmax;
wort        = parameters.ortoWeights;
lambda      = parameters.lambda;
orto        = ~isempty(wort);
saveall     = 0;
savelast    = 0;
%savedir     = strcat(datestr(now,'yy.mm.dd'),'.qpc_results');

log         = 0;



switch parameters.display
    case 'all'
        display = 2;
    case 'short'
        display = 1;
    case 'none'
        display = 0;
end

switch parameters.OptMethod
    case 'gd'
        opt = 1;
    
    case {'newton','fminunc'}
        opt = 2;
        if isempty(parameters.OptConf)
            parameters.OptConf=optimset('fminunc');
            parameters.OptConf.GradObj='on';
            if display>1 ; parameters.OptConf.Display='iter'; end
        end
        parameters.multistart = 'no';
    
    case 'fminsearch'
        opt = 3;
        if isempty(parameters.OptConf)
            parameters.OptConf=optimset('fminsearch');
            if display>1 ; parameters.OptConf.Display='iter'; end
        end
        parameters.multistart = 'no';

    case 'random'
        opt =4;
        parameters.multistart = 'no';
end

switch parameters.function
    case { 'gauss' , 'f_gauss'}
        func = @(xx)f_gauss(xx,beta);
    case { 'fx4' , 'f_x4'}
        func = @(xx)f_x4(xx,beta);
    case 'triangle'
        func = @(xx)f_triangular(xx,beta);
    case 'bicentral'
        func = @(xx)f_bicentral(xx,beta,0,10);
    otherwise
        error('Ten blad nie powinien wystapic - ale jesli wystapil to znaczy, ze jest cos nie tak z podana funkcja');
end

parameters.info.iter = 1;
switch parameters.QPCMethod
    case 'qpc'
         if (opt == 1 || opt == 4)   % gradient descent or random hill climbing
            qpcfun = @(wx,p)qpcfunction(x,ci,wx,[],func);    % podstawowa postac indeksu
         else            % minimalization 
             parameters.multistart = 'no';
             qpcfun = @(wx,p)qpcfunction_min(x,ci,wx,[],func);    % podstawowa postac indeksu
         end
    case 'quick'
         if (opt == 1 || opt == 2)   % gradient descent or random hill climbing
            error('Gradient based methods not suported for qpc_quick.');
         end
         parameters.multistart = 'no';
         if opt == 4
            qpcfun=@(w,p)-qpcfunction_quick(x,y,w,parameters.prototypes,[],parameters.beta);
         else
            qpcfun=@(w,p)qpcfunction_quick(x,y,w,parameters.prototypes,[],parameters.beta);
         end
    case 'proto'
        % uczenie QPC z wykorzystaniem prototypow.
        % Jesli prototypy nie sa dane to tworzymy tyle ile jest klass.
        if isempty(parameters.prototypes)
            parameters.prototypes = prototypes_init(x,y);
        elseif size(parameters.prototypes,2)==1
            parameters.prototypes = prototypes_init(x,y,parameters.prototypes);
        end
        
        parameters.multistart = 'no';
         if plr > 0 
             % optumalizacja wag oraz polozenia prototypow
             if (opt ~= 1)
                warrning('Switching to gradient descent learning');
                opt = 1;
             end
             qpcfun = @(wx,p)qpcfunction_dt(x,wx,p,func);  
         else
             if opt == 4
                 error('Random optimization for prototype learning not supported');
             end
             if opt == 1  % nieruchome prototypy
                qpcfun = @(wx)qpcfunction(x,ci,wx,parameters.prototypes,func);    % podstawowa postac indeksu
            else  % nieruchome prototypy
                 qpcfun = @(wx)qpcfunction_min(x,ci,wx,parameters.prototypes,func);    % podstawowa postac indeksu
             end
         end
    case {'uqpc1','uqpc2'}
        qpcfun=@(w,p)uqpc_function(x,w,p,func);
    otherwise
        error('Ten blad nie powinien wystapic - ale jesli wystapil to znaczy, ze jest cos nie tak z podana funkcja');
end

bestn = 0;
multistart = 1;
if strcmp(parameters.multistart,'no')
    multistart = 0;
    ninit = parameters.initiations;
 %   if (opt == 1); fprintf('Warning: single start for gradient descent deprecated - use multistart instead\n'); end
end

multiinit = parameters.initiations;
%ninit = 1;


if isempty(parameters.initWeights)
    w = rand(multiinit,fx)-1;       % random initialization [-0.5,0.5]
else
    w = parameters.initWeights;
    multiinit=size(w,1);
end


switch parameters.log
    case 'on'
        log = 1;
    case 'off'
        log = 0;
end

switch parameters.plot
    case 'all'
        plotall = 1;
    case 'qpc'
        iplot = 1;
        clf;
    case 'last'
        plotlast = 1;
end

if ~isempty(parameters.savedir)
    savedir = parameters.savedir;
end

switch parameters.save
    case 'all'
        plotall = 1;
        saveall = 1;
        log = 1;
    case 'last'
        plotlast = 1;
        savelast = 1;
        log = 1;
    case 'iplot'
        iplot = 1;
end


% if isempty(iGmax) 
%     if orto == 0
%         procedure = 'qpc';
%         % qpcfun = @(wx)qpcfunction(x,y,wx,func);    % podstawowa postac indeksu
%         qpcfun = @(wx)qpcfunction(x,y,x,y,wx,ci,func);    % podstawowa postac indeksu
%     else
%         procedure = strcat('qpc-orto',sprintf('.%0.1f',lambda));   % indeks 
%         wort=wort/norm(wort);
%         ortoproj = x*wort';
%         qpcfun = @(wx)qpcfunction(x,y,wx,func,wort,lambda);
%     end
% else 
%     procedure = strcat('qpc-gmax',sprintf('.%d',iGmax));
%     qpcfun = @(wx)qpcgmaxfunction2(x,y,wx,iGmax,func);
% end
% 


% Model info 
text = '';
if log == 1 || display > 0
    text = [
            sprintf('procedure     = %s\n',parameters.QPCMethod)...     
            sprintf('dataname      = %s\n',dataname)...
            sprintf('vectors       = %d\n',vx)...        
            sprintf('features      = %d\n',fx)...            
            sprintf('OptMethod     = %s\n',parameters.OptMethod)...     
            sprintf('learningRate  = %f\n',lrate)...
            sprintf('prototypes    = %d\n',size(parameters.prototypes,1))...
            sprintf('proto lr      = %f\n',plr)...
            sprintf('eps           = %f\n',eps)...           
            sprintf('start init.   = %d\n',multiinit)...
            sprintf('end init      = %d\n',leaven)...
            sprintf('multistart    = %s\n',parameters.multistart)...
            sprintf('maxIterations = %d\n',nmax)...          
            sprintf('qpc function  = %s\n',func2str(qpcfun))...
            sprintf('function      = %s\n',func2str(func))...
            sprintf('beta          = %f\n',beta)...          
        ];
    if orto == 1
        text = [text 'ortogonal W   = ' sprintf('%f  ',wort) '\n'...
                sprintf('lambda        = %f\n',lambda)...
        ]; 
    end
    if ~isempty(iGmax)
        text = [text sprintf('Gmax index    = %d\n',iGmax)];
    end
end

if log == 1
    %
    % fprintf(logfile,text);
end


if log == 1
    warning('Logging currently disabled');
%     [s comment]=mkdir(savedir);
%     if s == 0
%         error(comment);
%     end
% %    logfilename = parameters.logFile;
%     if isempty(parameters.logfilename)
%         prefix = strcat(savedir,'/',dataname,sprintf('.%s-%s.%0.1f',procedure,funcname,beta));
%     else
%         prefix=strcat(savedir,'/',parameters.logfilename);
%     end
%     logfilename = strcat(prefix,'.log');
%     logfile = fopen(logfilename,'wt');
%     if logfile == -1
%         error('Error opening %s file\n',logfilename);
%     end
%     fprintf(logfile,text);
end

if display > 0
    fprintf(text);
end




%%%%%%%%%%%%%%   OK - tu zaczyna sie zabawa %%

if opt ~= 1 || (multistart == 0 && ninit > 1)
    bestw = zeros(1,fx);
    bestqpc = -inf;
    bestinit = 0;
    for init = 1:ninit
        
        if display > 1 || log == 1
            text = sprintf('\nPerforming: Initialization %d of %d ',init,ninit);
%             if display > 1
%                 fprintf(text);
%             end
%             if log == 1
%                 %warrning('Logging currently disabled');
%                 % fprintf(logfile,text);
%             end
        end
        if opt == 1
            %%%%%%%%%%%%%%%%%%% standard gradient descent based method
            %%%%%%%%%%%%%%%%%%% whitout multistart (sequential initiations)
            param = parameters;
            param.initWeights = w(init,:);
            param.initiations = 1;
            param.display = 'none';
            param.directions = 1;
            param.log = 'off';
            param.save = 'none';
            param.plot = 'none';
           
            if display > 1; fprintf('%s gradient descent (sequential)\n',text); end
            [w1 qpc1 par1]=qpc_1d(x,y,param);
        
        elseif opt == 2   
            %%%%%%%%%%%%%%%%%%%  use 'fminunc' (gradient based) Matlab
            %%%%%%%%%%%%%%%%%%%  Optimization Tool
            if display > 1; fprintf('%s Quasi-Newton gradient descent (sequential)\n',text); end
            [w1 qpc1]=fminunc(qpcfun,w(init,:),parameters.OptConf);
            qpc1 = -qpc1;
            par1=parameters;
        elseif opt == 3 
            %%%%%%%%%%%%%%%%%%%  use 'fminsearch' (simplex ?!) Matlab
            %%%%%%%%%%%%%%%%%%%  Optimization Tool
            if display > 1; fprintf('%s not-gradient based search (sequential)\n',text); end
            [w1 qpc1]=fminsearch(qpcfun,w(init,:),parameters.OptConf);
            qpc1 = -qpc1;
            par1=parameters;
        elseif opt == 4 
            %%%%%%%%%%%%%%%%%%%  use random hill climbing (random
            %%%%%%%%%%%%%%%%%%%  projections)
            if display > 1; fprintf('%s random projections hill climbing (sequential)\n',text); end
            w1 = w(init,:);
            w1=w1./norm(w1);
            qpc1 = qpcfun(w1);
            par1=parameters;
        end
        if qpc1 > bestqpc
            parameters=par1;
            bestqpc = qpc1;
            bestw = w1;
            bestinit = init;
        end
    end
else    
            %%%%%%%%%%%%%%%%%%%  gradient descent procedure with multistart
            %%%%%%%%%%%%%%%%%%%  feature. Optimization is performed for all
            %%%%%%%%%%%%%%%%%%%  initiations SIMULTANEOUSLY and apropriet
            %%%%%%%%%%%%%%%%%%%  techniques for removing not interesting
            %%%%%%%%%%%%%%%%%%%  ones is applayed.

    bestn = 0;
    %bestigmax = -1;

    n = 0;
    qpctable = zeros(multiinit,nmax+1);

    if display > 0 || log == 1
        text = sprintf('Performing %d initiations - Gradient based optimization (MultiStart)\n',multiinit);
        if display > 0; fprintf(text); end
        if log == 1
           % fprintf(logfile,text);
        end
    end


    avgqpc = zeros(multiinit,1);
    lastavgqpc = zeros(multiinit,1);
    lastqpc = zeros(multiinit,1);
    initindex = 1:multiinit;
    lastn = ones(multiinit,1).*killPeriod;
    if (leaven > multiinit)
        leaven = multiinit;
    end
    if multiinit == 1 
        multistart = 0;
    end

    while ( 1 )
        currinit = length(initindex);
        if ( multistart == 1 && n == killPeriod + 1 ) % it's killing time
            index = selectBestInitiations(qpctable(initindex,1:n),leaven);
            disp('Sprawdzic dokladniej czy dobrze');
            initindex = initindex(index);
            avgqpc = avgqpc(index);
            lastavgqpc = lastavgqpc(index);

     %       bestindex = initindex;

            if display > 0
                fprintf('%d initiations was killed\n',currinit - length(initindex));
            end
         %   currinit = length(initindex);
%            fprintf('%d best initiations\n',length(bestindex));
        end

        % normalization
        for k=initindex
            w(k,:)=w(k,:)./norm(w(k,:));
        end

        [qpc dw dt] = qpcfun(w(initindex,:),parameters.prototypes);
        % note that: if qpcfun is a qpcfunction then dt is exual w*x
        % and where qpcfun is qpcfunction_dt or uqpc_function then dt is 
        % a prototype set.
        
        qpctable(initindex,n+1) = qpc;
        lastqpc(initindex,1) = qpc;

%         if nargout > 2
%             [gmax igmax] = max(G);
%         end

%       if nargout > 2  % wersja z ppioptimize5.m !!
%             lastG(initindex,:)=G;
%         end

        if iplot == 1 && n > 0
        %	plotqpc(qpctable,n,avgtest);
        %	plotqpc2(lastqpc(initindex),qpc,n,avgtest);
            plotqpc2(qpctable(initindex,n),qpctable(initindex,n+1),n,avgtest);
            drawnow;
        end

        if orto == 1
            w1 = w*wort';
        end

        if display > 1 || (display == 1 && n == 0) || log == 1
            if multistart == 1
               % text = 'Weihgt display not implemented for multistart\n';
            else
                text1 = strcat(sprintf('%3d  %10.6f   ',n,qpc),sprintf('  %6.4f',w));
                if orto == 1
                    text2 = sprintf('  [ %6.4f ] ',w1);
                else
                    text2 = '';
                end
                text = strcat(text1,text2,'\n');
            end
            if display > 1 || (display == 1 && n == 0)
%                fprintf(text);
            end
            if log == 1
                % fprintf(logfile,text); 
            end
        end

        if plotall == 1 && multistart == 0
            str=cell(1,3);
           clf;
          % hold off;
            set(gcf,'Color','w');
            if orto == 0

%               str{1} = strcat('w = ',sprintf(' %.2f ',w));
                str{2} = strcat('QPC = ',sprintf(' %.5f ',qpctable(n+1)));
                str{3} = strcat('N = ',sprintf(' %d ',n));

                bgraph3(x*w',y,'position',[0.05 0.4 0.9 0.50],'sigma',0.01,'function',func,'stralign','right','str',str,'weights',w);
                if plr > 0
                    fprintf('Warning - for plr > 0 this picture is not accurate')
                end
            else
                if plr > 0
                    fprintf('Warning - for plr > 0 this picture is not accurate')
                end
                str{2} = strcat('\alpha = ',sprintf(' %.4f ',w1));
                str{1} = strcat('QPC = ',sprintf(' %.4f ',qpctable(n+1)));
                str{3} = strcat('N = ',sprintf(' %d ',n));


                scaterplot([x*w' ortoproj],y,'str',str);

%                set(gca,'position',[0.1 0.45 0.85 0.50]);
%                xlabel(strcat('w2 = ',sprintf(' %.2f ',w)));
 %               ylabel(strcat('w1 = ',sprintf(' %.2f ',wort)));
                 xlabel(strcat('w2'));
                 ylabel(strcat('w1'));

            end
         %   axes('position',[0.1 0.1 0.85 0.25]);
         %   plotqpc(qpctable,n,50);
         %   drawnow();

            if saveall == 1
                warrning('Currently savealll option is disabled');
                %  saveplot(strcat(prefix,sprintf('.i%d.frame%04d',initcount,n)));
            end
        end;

%         if (stopcriterium == 1 && n > 1 && (abs((qpc - lastqpc)/lastqpc) < eps)  ) 
%             break;
%         end;

         if (n > 1 && mod(n,avgtest) == 0 && stopcriterium == 2)
            lastavgqpc = avgqpc;
            avgqpc = mean(qpctable(initindex,n-avgtest+1:n),2);

            select = abs((avgqpc - lastavgqpc)./lastavgqpc) > eps;
            if nnz(~select) > 0
                if display > 0
                    fprintf('Finish N = %d',n); fprintf('   QPC = %f ',qpc(~select)); fprintf('[%d ]',initindex(~select)); fprintf('\n'); disp(w(initindex(~select),:));
                end
                lastn(initindex(~select)) = n;
                initindex=initindex(select);

                dw = dw(select,:);
                qpc = qpc(select);
                avgqpc = avgqpc(select);
                lastavgqpc = lastavgqpc(select);
            end
            currinit = length(initindex);
        end;


%         if (stopcriterium == 2 && abs((avgqpc - lastavgqpc)/lastavgqpc) < eps && n > 1 ) 
%             break;
%         end;
        if ( n >= nmax  || isempty(initindex)) 
            break;
        end

%        w = w + lrate * dw - 0.005*w;
        w(initindex,:) = w(initindex,:) + lrate * dw ;
        if plr > 0
            parameters.prototypes(:,1:end-1)=parameters.prototypes(:,1:end-1) - dt.*plr;
        end
        n = n + 1;

    end;

   if (~isempty(initindex))
     lastn(initindex) = n;
     if display > 0
         fprintf('%d still not coverge\n',length(initindex));
     end
   end

%    disp(n);

%     if (display == 1)  % if display == 1 then display only last result
%         fprintf('%3d  %10.6f   ',n,bestqpc); 
%         fprintf('  %6.4f',bestw); 
%         if orto == 1
%                 fprintf('  [ %6.4f ] ',w1);
%         end
%         fprintf('\n');
%     end

    if plotlast == 1 && plotlast ~= 1   %narazie zakaz uruchamiania (poprawic)
            str=cell(1,3);
            clf;
            set(gcf,'Color','w');
            if orto == 0

%                str{1} = strcat('w = ',sprintf(' %.2f ',w));  % !! dla duzej ilosci wag wychodzi sieczka
                str{1} = strcat('QPC = ',sprintf(' %.5f ',qpctable(n+1)));
                str{2} = strcat('N = ',sprintf(' %d ',n));

                bgraph3(x*w',y,'sigma',0.01,'function',func,'str',str);
 %               bgraph3(x*w',y,'position',[0.05 0.4 0.9 0.50],'sigma',0.01,'function',func,'str',str);
            else
                str{2} = strcat('\alpha = ',sprintf(' %.4f ',w1));
                str{1} = strcat('QPC = ',sprintf(' %.4f ',qpctable(n+1)));
                str{3} = strcat('N = ',sprintf(' %d ',n));


                scaterplot([x*w' ortoproj],y,'str',str);

 %               set(gca,'position',[0.1 0.45 0.85 0.50]);
                xlabel(strcat('w2'));
                ylabel(strcat('w1'));

            end
%            axes('position',[0.1 0.1 0.85 0.25]);
%            plotqpc(qpctable,n,50);
            drawnow();

            if savelast == 1
                warrning('Currently savelast option is disabled');
%                saveplot(strcat(prefix,'.last'));
            end
    end;

% 	if (initcount == 1) || (qpc > bestqpc) 
% 		bestw = w;
% 		bestqpc = qpc;
% 		bestinit = initcount;
% 		bestn = n;
%         if nargout > 2
%             bestigmax = igmax;
%         end
%     end

%     %    disp('Removing relevant projections');
%     [ie ig]=sort(lastqpc(bestindex),'descend');
%     leaven = length(ie); 
%     select=ones(1,leaven);
%     ik = 1;
%     for k=2:leaven
%         if ( abs((w(bestindex(ig(ik)),:)* w(bestindex(ig(k)),:)')) >  alpha) 
%             select(k) = 0;
%         else
%             ik = k;
%         end
%     end
%     finalindex = bestindex(ig(select == 1));
% %    disp((w(finalindex,:)* w(finalindex,:)'));
%    
%    Wybieramy jeden najlepszy kierunek
    [bestqpc bestinit]=max(lastqpc);

    bestw = w(bestinit,:);
    parameters.info.iter = lastn(bestinit);
 %   bestqpc = lastqpc(finalindex);

%     if nargout > 2
%             lastG = lastG(finalindex,:);
%             [gmax igmax] = max(lastG,[],2);
%     end

    if display > 0
         fprintf('Best: %10.6f   ',bestqpc); 
         fprintf('  %6.4f',bestw); 
%         if orto == 1
%                 fprintf('  [ %6.4f ] ',w1);
%         end
         fprintf('\n');

    end
end

if display > 0 || log == 1
    text = ['---------------Sumary--------------------------\n' ...
            sprintf('Initialization  %d was the best\n',bestinit)...
            sprintf('N     QPC      W\n')...
            sprintf('%d  %6.4f    ',bestn,bestqpc)...
            sprintf('  %6.4f',bestw) sprintf('\n')...
            '-----------------------------------------------\n'];
    if display > 0
        fprintf(text);
    end
    if log == 1
     %   fprintf(logfile,text);
     %   fclose(logfile);
    end
end


function index=selectBestInitiations(qpctable,n)
% wybiera od n do 2*n  najlepszych (roznych) inicjaliacji, zwraca ich indeksy 

        no=size(qpctable,1);

        if n >= no
            index = 1:no;
            return
        end
        [ia ib]=sort(qpctable(:,end) - qpctable(:,1),'descend');  % is growing fast ?
        [ic id]=sort(qpctable(:,end),'descend');                  % is large enought?

        initindex1 = ib(1:n);
        initindex2 = id(1:n);

        index = unique([initindex1 initindex2]);

%        [ie ig]=sort(qpc(initindex),'descend');
%        leaven = length(ie); 
%        select=ones(1,leaven);          

% %      TU SLABO, poprawic - porownanie kazdy z kazdym il. skalarny i
% zostawiamy tylko unikatowe kierunki.
%         ik = 1;
%         for k=2:length(ie);
%             if ( abs((w(initindex(ig(ik)),:)* w(initindex(ig(k)),:)')) > 0.95) 
%                 select(k) = 0;
%             else
%                 ik = k;
%             end
%         end
%        initindex = initindex(ig(select == 1));
return

function saveplot(prefix)
    name = strcat(prefix,'.png');
    print('-dpng','-r96',name);
% % octave only
% %	print('-dpng','-S640,480',name);


%    name = strcat(prefix,'.eps');
%  	 print('-depsc',name);

function plotqpc(qpctable,n,scalefactor)
    if nargin < 3
        scalefactor = 10;
    end
    if nargin < 2
        n = length(qpctable);
    end
    xl = scalefactor.*(fix(n./scalefactor)+1);
    cla;
    hold on;
    xlim([0 xl]);
    xlabel('Iterations');
    ylabel('qpc value');
    plot(0:n,qpctable(1:n+1),'-b','LineWidth',2);
    box on;
    hold off;


function plotqpc2(ppilast,ppi,n,scalefactor)
    if nargin < 3
        scalefactor = 10;
    end
    xl = scalefactor.*(fix(n./scalefactor)+1);
    hold on;
    xlim([0 xl]);
    xlabel('Iterations');
    ylabel('QPC');
    plot([n-1 ; n]*ones(1,size(ppilast,1)),[ppilast ppi]','-b','LineWidth',1);
    box on;
