function [q dw dt]=qpcfunction_dt(x,ci,w,p,func,worto,lambda)
% wersja QPC z gradientem dt po pozycji prototypow t.
% moze byc wykozystana do uczenia pozycji prototypow (najlepiej niewielkiej
% liczby prototypow, gdyz liczba parametrow adaptacyjnych (k+1)*d

% UWAGA - PONIZSZY OPIS NIE AKTUALNY !!!

% QPCFUNCTION computes value of QPC index 
%    Q = QPCFUNCTION(X,Y,W) computes value of QPC index for given dataset
%    X, label table Y and direction W (weights).
%
%  QPC(w)=sum_i sum_j  A_ij* G(w*(x_i-t_j)))
% where A_ij = -1 if class(x) ~= class(t), A_ij = 1 if class(x) == class(t)
%
%    X - unlabeled data
%    Y - vector of labels or CLASSSTAT struct  (CLASSSTAT(Y))
%    W - weight wector (direction of projection)
%
%    Q = QPCFUNCTION(X,Y,W,P) computes value of QPC whith prototypes P, where last column P(:,end) are associated labels
%         If P is not given or P=[] then all datapoints are used P=[X Y]
%
%    Q = QPCFUNCTION(X,Y,W,P,FUNC) computes value of QPC index with given function FUNC (function handle, default FUNC=@(x)F_GAUSS(x,0.1)).
%
%    Q = QPCFUNCTION(X,Y,W,P,FUNC,WO,LAMBDA) computes value of QPC index with
%    additional ortogonalization term with given scalar LAMBDA and vector WO (ortogonal weights vector) 
%
%    [Q DQ] = QPCFUNCTION(...) returns value of gradient df/dx, the
%    function FUNC must return it's gradient value as a secound output.
%
%    [Q DQ PROJ] = QPCFUNCTION(...) returns value PROJ=X*W' (linear projection on dorection W), for some
%    reasons may be usefull.
%
%   [Q DQ PROJ G] = QPCFUNCTION(...) returns table of values of QPC
%   index partial values for each vector, where G_i = sum_k FUNC( (X_i - X_k)*W')
%   
%Funkcja oblicza wartosc indexsu QPC, dla danych wektorow X oraz etykiet
% klas Y oraz podanego kierunku W i funkcji FUNC.
% Wartosci zwracane: 
%   Q  - wartosc indexu
%   DQ - pochodna funkcji 
%   PROJ - rzyt x*w' - mozna wykozystac w dalszych obliczeniach aby nie
%           powtarzac tej operacji wielokratnie
%   G    - tablica wartosci dla kazdego z wektorow  QPC = 1/A sum G(x)
% CI = class info given by classstat(y)
%
% Poprzednia wersja pliku : ppifunction.m

ninit = size(w,1);

if nargin < 7
    lambda = 1;
end
if ( nargin < 6 )
    lambda = 0;
end

if  nargin < 5 || isempty(func)
    func=@(x)f_gauss(x,0.1);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end

if nargin < 4 
     p = [];
end

if isa(ci,'numeric')
    ci=classstat(ci);
end

[vectorsCount featuresCount] = size(x);

projection = x*w';
if isempty(p)
    tw = projection;
    np = vectorsCount;
else
    tw = p(:,1:end-1)*w';
    np = size(p,1);
end

G = zeros(ninit,vectorsCount);
A = zeros(1,np);

if ninit == 1
    dt=zeros(np,featuresCount);
else
    dt=zeros(np,ninit,featuresCount);
end

if nargout > 1
    dw =zeros(ninit,featuresCount);
end

for i=1:np
    if isempty(p)
       ii = ci.index(i);
    else
        ii= p(i,end) == ci.labels;
    end
    lc = ci.labelsPerClassCount(ii);
 
    A(ci.labelsIndex{ii}) = 1/lc;
    A(~ci.labelsIndex{ii})=-1/(vectorsCount-lc);

    if nargout == 1
        f  = func(projection - tw(i.*ones(vectorsCount,1),:));
    else
        [f df] = func(projection - tw(i.*ones(vectorsCount,1),:));
    end

    G(:,i) = A*f; 
     if nargout > 1
         if isempty(p)
            xd = x - x(i.*ones(vectorsCount,1),:);
         else
             xd = x - p(i.*ones(vectorsCount,1),1:end-1);
         end
         dw = dw + df'.*A(ones(ninit,1),:)*xd;
     end
     if nargout > 2
         if ninit == 1
             dt(i,:)=(A*df)*w;
         else
           tmp=(A*df)';
           dt(i,:,:) = tmp(:,ones(1,featuresCount)).*w;
         end
         
%         
     end
end
q = sum(G,2)./np;

if nargout > 1
    dw =dw./np;
end
if lambda ~= 0
   % tutaj czesc ortonormalizacyjna
   [fw dfw]=ortof(w,worto,lambda);
   qpc = qpc  - fw;
   if nargout > 1
        dqpc = dqpc - dfw;
   end
end
