function [qpc prototypes sigma]=qpcfunction_quick(x,ci,w,k,func,wh)
%function qpc=qpcfunction_quick(x,ci,w,k,wh,func,worto,lambda)
% opcja wh okrezla sigma = wh*h (przetestowac dla wh = 1 i 0.5)
% Index QPC aproksymowany przedzialami.
%
%function [qpc dqpc projection G]=qpcfunction_quick(x,ci,w,k,func,worto,lambda)
% QPCFUNCTION computes approximated value of QPC index for given dataset [X Y] and direction W.
%
%  Note that this help is obsolete and not all options might be impelemented.
%
%    Q = QPCFUNCTION(X,Y,W) computes value of QPC index for given dataset
%    X, label table Y and direction W (weights).
%
%  QPC(w)=sum_i sum_j  A_ij* G(w*(x_i-t_j)))
% where A_ij = -1 if class(x) ~= class(t), A_ij = 1 if class(x) == class(t)
%
%    X - unlabeled data
%    Y - vector of labels or CLASSSTAT struct  (CLASSSTAT(Y))
%    W - weight wector (direction of projection)
%
%    Q = QPCFUNCTION(X,Y,W,P) computes value of QPC whith prototypes P, where last column P(:,end) are associated labels
%         If P is not given or P=[] then all datapoints are used P=[X Y]
%
%    Q = QPCFUNCTION(X,Y,W,P,FUNC) computes value of QPC index with given function FUNC (function handle, default FUNC=@(x)F_GAUSS(x,0.1)).
%
%    Q = QPCFUNCTION(X,Y,W,P,FUNC,WO,LAMBDA) computes value of QPC index with
%    additional ortogonalization term with given scalar LAMBDA and vector WO (ortogonal weights vector) 
%
%    [Q DQ] = QPCFUNCTION(...) returns value of gradient df/dx, the
%    function FUNC must return it's gradient value as a secound output.
%
%    [Q DQ PROJ] = QPCFUNCTION(...) returns value PROJ=X*W' (linear projection on dorection W), for some
%    reasons may be usefull.
%
%   [Q DQ PROJ G] = QPCFUNCTION(...) returns table of values of QPC
%   index partial values for each vector, where G_i = sum_k FUNC( (X_i - X_k)*W')
%   
%Funkcja oblicza wartosc indexsu QPC, dla danych wektorow X oraz etykiet
% klas Y oraz podanego kierunku W i funkcji FUNC.
% Wartosci zwracane: 
%   Q  - wartosc indexu
%   DQ - pochodna funkcji 
%   PROJ - rzyt x*w' - mozna wykozystac w dalszych obliczeniach aby nie
%           powtarzac tej operacji wielokratnie
%   G    - tablica wartosci dla kazdego z wektorow  QPC = 1/A sum G(x)
% CI = class info given by classstat(y)
%

ninit = size(w,1);

if nargin < 6;  wh = 1; end
if  nargin < 5 || isempty(func)
    func=@(x,s)f_gauss(x,s);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end
if nargin < 4 || isempty(k); k = 10 ; end

if isa(ci,'numeric')
    ci=classstat(ci);
end


%[vectorsCount featuresCount] = size(x);

projection = x*w';
yminmax=minmax(projection');
h = (yminmax(:,2)-yminmax(:,1))./k;
qpc =0;


% disp(ninit);
% disp(h);
% disp(func);
% disp(wh);
% disp(k);


if ninit == 1
    Tc = zeros(ci.labelsCount,k);
    t= yminmax(:,1) +  h*((1:k)-0.5);
    sigma = wh*h;
    
    for i=1:k
 %       if nargout == 1
            for c=1:ci.labelsCount
                Tc(c,i)=sum(func(projection(ci.labelsIndex{c}) - t(i),sigma))./ci.labelsPerClassCount(c);
            end
  %      else
        %    [f df]=func(projection(ci.labelsIndex{c}) - t(i),sigma);
        %    error('Not implemented');
   %     end
    
    
    end
 %   Tc
    [a mI]=max(Tc);
    
%    zz=mI+(0:ci.labelsCount:ci.labelsCount*(k-1));   % polozenie max. w macierzy
    
    for i = 1:ci.labelsCount
        ind = mI == i;
        if nnz(ind) ~= 0
    %        aa=sum(Tc(i,ind))./nnz(ind)
%        bb=sum(Tc(i,~ind))./nnz(~ind)
            qpc = qpc + sum(Tc(i,ind))./nnz(ind) - sum(Tc(i,~ind))./nnz(~ind);
        end
    end
    qpc=-qpc./ci.labelsCount;

else
    t = yminmax(:,ones(1,k)) +  h*([1:k]-0.5);
    error('Multi init not iplemented');
end
if nargout > 1
%    ci.labels(mI)
   prototypes=[t' ci.labels(mI)'];

end

return ;


