function [bestw bestqpc info]=qpctrain(x,y,varargin)
%function [bestw bestqpc qpctable]=qpctrain(x,y,varargin)
% QPCTRAIN runs optimalization proces of QPC index for given dataset X and labels Y.
%
%   W = QPCTRAIN(X,Y,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize QPC index value
%	X : dataset
%	Y : labels
%  
%   Run "help qpc_config" for details.
%
%	e.g.   w=qpctrain(x,y,'function','triangular','beta',3,'plot','qpc')
%		use triangular function with beta = 3 and plot change of qpc function douring learning (function width)
%
% TODO : 
%   * document all parameters and options (almost done)
%   * implementation of diferent optimalization methods: e.g. sim. aneling
%   (see MATLAB docs)
%   * simple gui for controling and visualization of optimalization
%   * new pictures - G values, weights values as bar plot, ... 
%   * improve log saving and results displaing   
%

parameters = qpc_config(varargin{:});

%directions  = parameters.directions;
%ortmethod   = param.Results.orthogonalizationMethod;

%fprintf('Input parameters:\n\n');
%disp(param.Results);
%disp(param.Parameters);

qpclearning=@(x,y,p)qpc_1d(x,y,p);

[vx fx]=size(x);

bestw = zeros(parameters.directions,fx);
bestqpc = zeros(parameters.directions,1);

str=cell(1,1);

if parameters.directions > fx; parameters.directions = fx ; end 

%xp=x;

x1=zeros(vx,parameters.directions);

iflog =  (strcmp(parameters.log,'on')  || strcmp(parameters.save,'none') ~= 1);

if isempty(parameters.savedir) && iflog
    savedir = strcat(datestr(now,'yy.mm.dd'),sprintf('.%s/',parameters.QPCMethod));
end

if isempty(parameters.logFileName) && iflog
    logfilename = sprintf('%s%s.%s.%s.%s.%0.1f',savedir,parameters.dataName,parameters.QPCMethod,parameters.OptMethod,parameters.function,parameters.beta);
    if size(parameters.prototypes,2) == 1
        % POPRAWIC 
        logfilename=strcat(logfilename,sprintf('.k%d',parameters.prototypes));
    end
end

%
for dirCount = 1:parameters.directions
    if dirCount == 1
        P =  [];
        xp = x;
    else
        P=eye(fx)-bestw'*bestw;  % operator projekcji na podprz. otronormalna
        xp=x*P;        
    end

    [bw bqpc param]=qpclearning(xp,y,parameters);
    
    if dirCount > 1
        bw=bw*P;
    end
    
    bestw(dirCount,:)=bw/norm(bw);
    
    bestqpc(dirCount)=bqpc;
    info{dirCount} = param.info;

    % Partial results logging (plot bgraph for given direction and scatterplots for each features pair).
    if iflog
        x1(:,dirCount)=x*bw';
        str{1}=sprintf('QPC = %0.3f',bqpc);
        clf;
        bgraph(x1(:,dirCount),y,'weights',bw,'str',str,'stralign','right');
        saveplot(sprintf('%s.bgraph.d%d',logfilename,dirCount));
        for f=2:dirCount
            clf;
            scaterplot(x1,y,[f-1 dirCount]);
            saveplot(sprintf('%s.scatterplot.d%d-%d',logfilename,f-1,dirCount));
        end
    end
end


% Final results logging.
if parameters.directions > 1 && iflog
    clf;
    scaterplot(x*bestw',y,1:directions);
    saveplot(sprintf('%s.scatterplot.all',logfilename));
    plik=fopen(sprintf('%s.all.log',logfilename),'w');
    for i=1:directions
        fprintf(plik,sprintf('Direction %2d\n',i));
        fprintf(plik,sprintf('QPC=%6.4f\n',bestqpc(i)));
        fprintf(plik,strcat('w=',sprintf(' %6.4f',bestw(i,:))));
        fprintf(plik,'\n');
    end
    fclose(plik);
end

    

