function runcvtest_LLVQ(inputpath)
% CV LLVQNET

if isdir(inputpath) == 1
    ft = ls(inputpath);
    files = ft(3:end,:);
    dir=strcat(inputpath,'/');
else
    files=inputpath;
    dir='';
end

folds = 3;
tests = 1;
%method='pca';
method='qpc';

init = 5;      % number of initiations
lvqlr = 0.01;  %learningRate
llrate =0.05; 
proj = 5 ;     % max. ilosc kierunkow
krange=[2 10 20]; 
epsilon = 0.03; 
lup = 10;  %llupdate 

savedir = strcat(datestr(now,'yy.mm.dd'),'.cvtest2/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv2.log');
%logfilename=strcat(datestr(now,'yy.mm.dd'),'.cv2.log');
logfile = fopen(logfilename,'wt');


model.train = @(xx,yy)llvqnetwork(xx,yy,method,init,lvqlr,llrate,proj,krange,lup,epsilon);
model.test = @(xx,yy,zz)llvqnettest(xx,yy,zz);

fprintf(logfile,'   Method            lvq+%s\n',method);
fprintf(logfile,'   Initialization    %d\n',init);
fprintf(logfile,'   LVQ learnign rate %f\n',lvqlr);
fprintf(logfile,'   Attraction force  %f\n',llrate);
fprintf(logfile,'   Max. projections  %d\n',proj);
fprintf(logfile,'   K range           %s\n',sprintf('%d ',krange));
fprintf(logfile,'   Attraction step   %d\n',lup);
fprintf(logfile,'   Precision (eps)   %f\n',epsilon);
fprintf(logfile,'\n');  

fprintf(logfile,'^ Dataset        ^^^  Model  ^^^^^^\n');
fprintf(logfile,'|                   |   vec  |  feat  |    acc.  |   std.  |    #P   |   std.  |    #K   |   std.  |\n');

n=size((files),1);
for i=1:n
%    try 
        file=strcat(dir,files(i,:));
        [d datasetname]=fileparts(file);
        data = load(file);
        [v f]=size(data);
        if (nargin < 2)
             x=data(:,1:end-1);
        else
             x=normalize(data(:,1:end-1));
        end;
        y=data(:,end);
        
        fprintf('dataset: %s %5d vectors %5d features loaded\n',datasetname,v,f-1);
        fprintf(logfile,'|  %16s |  %5d |  %5d | ',datasetname,v,f-1);

%        [avgacc avgstd avgneurons stdneurons accall nodes]= multitest(x,y,folds,tests);
%         [avgacc avgstd avgwneurons stdwneurons avgpneurons stdpneurons accall]= multitest(x,y,model,folds,tests);
         results= multitest(x,y,model,folds,tests);

         saveresults(results,strcat(savedir,datasetname,'.',method,'-cv'));
        
        fprintf(logfile,'  %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg,results.hidden_std,results.output_avg,results.output_std);

% stara wersja matlaba
  %  catch
%        disp(lasterror);
% w nowej wersji MATLABA
%     catch M
%         fprintf(logfile,'    --   Exception\n');
%         disp(M);
%    end
    %    ppoptimize2(x,y(:,end),'lrate',0.2,'fx4',10,'plotall','eps',0.005,'dataname',strcat(files(i,:),'-fx4-10'));
end
%par = load('../parity-4.dat');
fclose(logfile);


function saveresults(results,filename)

    f=fopen(filename,'w');
    fprintf(f,'Accuracy \n');
    n = size(results.accuracy,1);
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.accuracy(i,:)));
    end
    fprintf(f,'Projections (hidden nodes) \n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.hidden(i,:)));
    end
    fprintf(f,'Prototypes (output nodes)\n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.output(i,:)));
    end
    fprintf(f,'|  acc.  |   std.  |    #P   |   std.  |    #K   |   std.  |\n');
    fprintf(f,'| %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg,results.hidden_std,results.output_avg,results.output_std);
    fclose(f);
%         save(strcat(savedir,nname),'-ASCII','results');
%         save(strcat(savedir,nname),'-ASCII','avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         save(strcat(savedir,nname,'.mat'),'avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         avgacc=99.111;         avgstd=0.11111;         avgwneurons=154.2;         stdwneurons=21.4;        avgpneurons=111.2;         stdpneurons=5.1;        accall=3;
