function runcvtestMLP(inputpath)
% test CV MLP

if isdir(inputpath) == 1
    ft = dir(inputpath);
    fn = size(ft,1)-2;   
    files=cell(fn,1);
    
    for i=1:fn
        files{i}=ft(i+2).name;
    end
    basedir=strcat(inputpath,'/');
else
    files={inputpath};
    basedir='';
    fn=1;
end

folds = 10;
tests = 1;
method='MLP';

init = 5;  % number of initiations
lr = 0.1;  % learningRate

noderange = 0:20; 
epsilon = 0.001; 
maxiter=1000;

savedir = strcat(datestr(now,'yy.mm.dd'),'.cvtestMLP/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv4.log');
%logfilename=strcat(datestr(now,'yy.mm.dd'),'.cv2.log');
logfile = fopen(logfilename,'wt');

model.test =@(xx,yy,zz)mlptest(xx,yy,zz);

fprintf(logfile,'   Method            %s\n',method);
fprintf(logfile,'   Max. iterations   %d\n',maxiter); 
fprintf(logfile,'   Learning rate     %f\n',lr);
fprintf(logfile,'   nodes range       %s\n',sprintf('%d ',noderange));
fprintf(logfile,'   Precision (eps)   %f\n',epsilon);
fprintf(logfile,'\n');  

fprintf(logfile,'^ Dataset        ^^^  Model  ^^^^^^\n');
fprintf(logfile,'|                  |  acc.  |  std.  |  #K  |\n');



for i=1:fn
%    try 
        file=strcat(basedir,files{i,:});
        
        [d datasetname]=fileparts(file);
        data = load(file);
        [v f]=size(data);
        if (nargin < 2)
             x=data(:,1:end-1);
        else
             x=normalize(data(:,1:end-1));
        end;
   %     y=normalize(data(:,end));   % UWAGA tylko dla danych dwuklasowych
        y=data(:,end);
        fprintf('dataset: %s %5d vectors %5d features loaded\n',datasetname,v,f-1);
 
        for n=noderange
            %model.train = @(xx,yy)lvqnetwork(xx,yy,lvqlr,k,init,epsilon);
            

        model.train=@(x,y)mlptrain(x,y,n,lr,maxiter,eps);

            
            fprintf(logfile,'| %-16s |',datasetname);
            results= multitest(x,y,model,folds,tests);

            %           saveresults(results,strcat(savedir,datasetname,'.',method,'-cv'));
            fprintf(logfile,'  %5.1f |  %5.1f |  %3d |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg);
        end
end
fclose(logfile);


function saveresults(results,filename)

    f=fopen(filename,'w');
    fprintf(f,'Accuracy \n');
    n = size(results.accuracy,1);
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.accuracy(i,:)));
    end
    fprintf(f,'Projections (hidden nodes) \n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.hidden(i,:)));
    end
    fprintf(f,'Prototypes (output nodes)\n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.output(i,:)));
    end
    fprintf(f,'|  acc.  |   std.  |    #P   |   std.  |    #K   |   std.  |\n');
    fprintf(f,'| %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg,results.hidden_std,results.output_avg,results.output_std);
    fclose(f);
%         save(strcat(savedir,nname),'-ASCII','results');
%         save(strcat(savedir,nname),'-ASCII','avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         save(strcat(savedir,nname,'.mat'),'avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         avgacc=99.111;         avgstd=0.11111;         avgwneurons=154.2;         stdwneurons=21.4;        avgpneurons=111.2;         stdpneurons=5.1;        accall=3;
