function runcvtest6(inputpath)
% test CV QPC + MLP ze zmienna iloscia neuronow

if isdir(inputpath) == 1
    ft = ls(inputpath);
    files = ft(3:end,:);
    dir=strcat(inputpath,'/');
else
    files=inputpath;
    dir='';
end

folds = 6;
tests = 1;
method='QPCMLP';
qpcdirections=1;

noderange = 3:3; 
% epsilon = 0.01; 
% init = 5;      % number of initiations
lr = 0.1;  %learningRate
maxiter=1000;

savedir = strcat(datestr(now,'yy.mm.dd'),'.cvtest6/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv8.log');
%logfilename=strcat(datestr(now,'yy.mm.dd'),'.cv2.log');
logfile = fopen(logfilename,'wt');

model.test =@(xx,yy,zz)qpcmlptest(xx,yy,zz);

fprintf(logfile,'   Method            %s\n',method);
% fprintf(logfile,'   Initialization    %d\n',init);
% fprintf(logfile,'   LVQ learnign rate %f\n',lvqlr);
fprintf(logfile,'   nodes range           %s\n',sprintf('%d ',noderange));
% fprintf(logfile,'   Precision (eps)   %f\n',epsilon);
fprintf(logfile,'   qpc projections   %s\n',sprintf('%d ',qpcdirections));
fprintf(logfile,'\n');  

fprintf(logfile,'^ Dataset        ^^^  Model  ^^^^^^\n');
fprintf(logfile,'|                  |  acc.  |  std.  |  #K  |\n');

n=size((files),1);
for i=1:n
%    try 
        file=strcat(dir,files(i,:));
        [d datasetname]=fileparts(file);
        data = load(file);
        [v f]=size(data);
        if (nargin < 2)
             x=data(:,1:end-1);
        else
             x=normalize(data(:,1:end-1));
        end;
        y=normalize(data(:,end));   % UWAGA tylko dla danych dwuklasowych
        
        fprintf('dataset: %s %5d vectors %5d features loaded\n',datasetname,v,f-1);
 
        for n=noderange
            %model.train = @(xx,yy)lvqnetwork(xx,yy,lvqlr,k,init,epsilon);

     %       model.train=@(x,y)qpcmlptrain(x,y,n,qpcdirections);
            model.train=@(x,y)qpcmlptrain(x,y,n,lr,maxiter,eps,qpcdirections);
            fprintf(logfile,'| %-16s |',datasetname);
            results= multitest(x,y,model,folds,tests);

            %           saveresults(results,strcat(savedir,datasetname,'.',method,'-cv'));
            fprintf(logfile,'  %5.1f |  %5.1f |  %3d |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg);
        end
end
fclose(logfile);


function saveresults(results,filename)

    f=fopen(filename,'w');
    fprintf(f,'Accuracy \n');
    n = size(results.accuracy,1);
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.accuracy(i,:)));
    end
    fprintf(f,'Projections (hidden nodes) \n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.hidden(i,:)));
    end
    fprintf(f,'Prototypes (output nodes)\n');
    for i=1:n
        fprintf(f,'%s\n',sprintf(' %5.2f',results.output(i,:)));
    end
    fprintf(f,'|  acc.  |   std.  |    #P   |   std.  |    #K   |   std.  |\n');
    fprintf(f,'| %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |  %6.2f |\n',results.accuracy_avg,results.accuracy_std,results.hidden_avg,results.hidden_std,results.output_avg,results.output_std);
    fclose(f);
%         save(strcat(savedir,nname),'-ASCII','results');
%         save(strcat(savedir,nname),'-ASCII','avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         save(strcat(savedir,nname,'.mat'),'avgacc','avgstd','avgpneurons','stdpneurons','avgwneurons','stdwneurons','accall');
%         avgacc=99.111;         avgstd=0.11111;         avgwneurons=154.2;         stdwneurons=21.4;        avgpneurons=111.2;         stdpneurons=5.1;        accall=3;
