function runtest8(inputpath)

% uczenie llvq

files = dir(inputpath);

if isdir(inputpath) == 1
    directory=strcat(inputpath,'/');
else
    directory=strcat(fileparts(inputpath),'/');
end

%method='pca';
method='qpc';
init = 5;      % number of initiations
lvqlr = 0.01;  %learningRate
llrate =0.05; 
proj = 5 ;     % max. ilosc kierunkow
krange=[2 10 20]; 
epsilon = 0.02; 
lup = 100;  %llupdate 
%krange = 3;
% PCA

savedir = strcat(datestr(now,'yy.mm.dd'),'.runtest8/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.rt8.log');
%logfilename=strcat(datestr(now,'yy.mm.dd'),'.cv2.log');
logfile = fopen(logfilename,'wt');

model.train = @(xx,yy)llvqnetwork(xx,yy,method,init,lvqlr,llrate,proj,krange,lup,epsilon);
model.test = @(xx,yy,zz)llvqnettest(xx,yy,zz);
% 
% linearizator=@(x,y,ik,ip)llvqtrain(x,y,ik,'initp',ip,'lvqlr',lvqlr,'llrate',llrate,'llupdate',10);  model = 'pca';
% % QPC     
% %linearizator=@(x,y,ik,ip)llvqtrain2(x,y,ip,ik,lvqlr,5,1); model ='qpc';
% epsilon = 0.03; % 

fprintf(logfile,'   Method            lvq+%s\n',method);
fprintf(logfile,'   Initialization    %d\n',init);
fprintf(logfile,'   LVQ learnign rate %f\n',lvqlr);
fprintf(logfile,'   Attraction force  %f\n',llrate);
fprintf(logfile,'   Max. projections  %d\n',proj);
fprintf(logfile,'   K range           %s\n',sprintf('%d ',krange));
fprintf(logfile,'   Attraction step   %d\n',lup);
fprintf(logfile,'   Precision (eps)   %f\n',epsilon);
fprintf(logfile,'\n');  

fprintf(logfile,'^ Dataset        ^^^  Model  ^^^^^^\n');
fprintf(logfile,'|                   |   vec  |  feat  |    acc.  |   #P  |    #K   | \n');

n=size((files),1);
for i=1:n
    %try 
        if files(i).isdir == 1
            continue
        end
        file=strcat(directory,files(i).name);
        [path datasetname]=fileparts(file);
        
        data = load(file);
        [v f]=size(data);
        x=normalize(data(:,1:end-1));
        y=data(:,end);
        disp(['dataset: ' datasetname sprintf('\t%5d',v) ' vectors ' sprintf(' %5d',f-1) ' features ' ' loaded']);
        prefix=strcat(savedir,sprintf('%s.%s',datasetname,method));

%        llvqoptimize4(x,y,krange,lvqlr,proj,init,prefix,linearizator,epsilon);
        net = model.train(x,y);
 %       acc = model.test(x,y,net);
        fprintf(logfile,'| %-16s  |  %5d |  %5d | ',datasetname,v,f-1);
        fprintf(logfile,'  %6.2f |  %6.2f |  %6.2f |\n',net.trainacc,net.nw,net.np);        

        f = fopen(strcat(prefix,'.log'),'w');

        ci=classstat(y);
        fprintf(f,'Dataname          %s\n',datasetname);
        fprintf(f,'Vectors           %d\n',v);
        fprintf(f,'Features          %d\n',f);
        fprintf(f,'Classes           %d [ %s]\n',ci.labelsCount,sprintf('%d ',ci.labels));
        fprintf(f,'Method            lvq+%s\n',method);
        fprintf(f,'K range           %s\n',sprintf('%d ',krange));
        fprintf(f,'LVQ lrate         %.3f\n',lvqlr);
        fprintf(f,'Lin. rate         %.3f\n',llrate);
        fprintf(f,'Max. Projections  %d\n',proj);
        fprintf(f,'Initializations   %d\n',init);

        fprintf(f,'\nBest solution\n');
        fprintf(f,'Projections %d, prototypes %d, accuracy = %.2f\n',net.nw,net.np,net.trainacc);
        fprintf(f,'Prototypes\n');
        for ki=1:net.np
             fprintf(f,'%s %d\n',sprintf(' %.3f',net.p(ki,1:end-1)),net.p(ki,end)); 
         end

        fprintf(f,'\nWeights\n');
        fprintf(f,'%s\n',sprintf(' %5dF',1:size(net.w,2))); 
        for pi=1:net.nw
            fprintf(f,'%s\n',sprintf(' %6.3f',net.w(pi,:))); 
        end
        fclose(f);

        plotresult(x,y,net.w,net.p,prefix);

        
        
% stara wersja matlaba
    
%     catch
%         file=fopen('debug.log','a');
%         err=lasterror;
%         fprintf(file,'\n%s\n  Message: %s\n  file: %s\n  name: %s\n  line: %d\n',datestr(now),err.message,err.stack.file,err.stack.name,err.stack.line);
%         save 'xxx' err
%         fclose(file);
% 
% % w nowej wersji MATLABA
% %     catch M
% %         disp(M);
%     end
end


function plotresult(x,y,w,p,prefix)

wn=size(w,1);
if wn == 1
        clf;
         bgraph3(x*w',y);
         hold on;

         bgraph3(p(:,1:end-1),p(:,end),'select','yes','borders','yes');% ,'borders','yes');         
         print('-dpng','-r96',sprintf('%s.bgraph.png',prefix));
else
         clf;
         scaterplot(x*w',y,1:wn);
         hold on;
         scaterplot(p(:,1:end-1),p(:,end),1:wn,'select','yes','borders','yes');         
         print('-dpng','-r96',sprintf('%s.all.scatter.png',prefix));
end
return;


