function [all_qpc_results all_qpcproto_results]=runtest_icann2010_speed(inputpath)
% porownanie jakosci i szybkosci uczenia QPC i QPC_proto (ze zmiennym
% polozeniem prototypow inicjowanym za pomoca qpc_quick).

if nargin < 1
%    inputpath='c:\\_users\grochu\work\matlab\qpc\data\';  
    inputpath = '/home/marek/data/test/';
end

data = data_load(inputpath);

savedir = strcat(datestr(now,'yy.mm.dd'),'.icann2010_qpc_speed/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

lr=0.1;
directions=1;
plr=0.1;
n=size(data,2);
all_qpcproto_results=cell(n,1);
all_qpc_results=cell(n,1);
randominit=10;
repetitions = 10;
init =10;
intervals = 20;

for i=1:n
        data(i).x=normalize(data(i).x);
        %data(i).y;
        
        results.dataname = data(i).name;
        results.vectors = data(i).vectors;
   
        disp(['dataset= ' data(i).name sprintf('\t%5d',data(i).vectors) ' vectors ' sprintf(' %5d',data(i).features) ' features ' ' loaded']);
        filename=strcat(savedir,sprintf('%s.qpc_proto.quick.k%d',data(i).name,intervals));
        f=fopen(strcat(filename,'.all.log')','w');
        fprintf(f,'dataset= %s\nvectors= %d\nfeatures= %d\n\n',data(i).name,data(i).vectors,data(i).features);
        
        results.aqpc = zeros(1,repetitions); 
        results.qpc = zeros(1,repetitions); 
        results.time = zeros(1,repetitions); 
        results.iter = zeros(1,repetitions); 
        
        for r=1:repetitions
            fprintf('Evaluating QPC_proto repetition %d of %d\n',r,repetitions);
            [qpc time iter aqpc]=qpctrain_proto_test(data(i),init,randominit,lr,plr,intervals);
            
            fprintf(f,'Method= QPC_proto\nrepetition=%d\ntime= %f\nQPC=%f\naQPC=%f\niterations=%d\n\n',r,time,qpc,aqpc,iter);

            results.aqpc(r) = aqpc;
            results.qpc(r) = qpc;
            results.time(r) = time;
            results.iter(r) = iter;
        end
        
        results.aqpc_avg =  mean(results.aqpc);
        results.qpc_avg = mean(results.qpc);
        results.time_avg = mean(results.time); 
        results.iter_avg = mean(results.iter);

        results.aqpc_std =  std(results.aqpc);
        results.qpc_std = std(results.qpc);
        results.time_std = std(results.time); 
        results.iter_std = std(results.iter);
    
        fprintf(f,'---------------------------\n');
        fprintf(f,'Average over %d trials\n',repetitions);
        fprintf(f,'QPC= %f %f\n',results.qpc_avg,results.qpc_std);
        fprintf(f,'aQPC= %f %f\n',results.aqpc_avg,results.aqpc_std);        
        fprintf(f,'time= %f %f\n',results.time_avg,results.time_std);
        fprintf(f,'iter= %f %f\n',results.iter_avg,results.iter_std);
        fprintf(f,'\nSummary dataname/qpc/time/iter:\n%s %.2f %.2f %.2f %.2f %.1f %.1f\n',data(i).name,results.qpc_avg,results.qpc_std,results.time_avg,results.time_std,results.iter_avg,results.iter_std);

        fclose(f);

        all_qpcproto_results{i}=results;
        clear results;
        
        %%%%%%%%%% to samo dla tradycyjnego QPC

    
        results.dataname = data(i).name;
        results.vectors = data(i).vectors;
   
        disp(['dataset= ' data(i).name sprintf('\t%5d',data(i).vectors) ' vectors ' sprintf(' %5d',data(i).features) ' features ' ' loaded']);
        filename=strcat(savedir,sprintf('%s.qpc.gauss.0.1',data(i).name));
        f=fopen(strcat(filename,'.all.log')','w');
        fprintf(f,'dataset= %s\nvectors= %d\nfeatures= %d\n\n',data(i).name,data(i).vectors,data(i).features);
        
        results.qpc = zeros(1,repetitions); 
        results.time = zeros(1,repetitions); 
        results.iter = zeros(1,repetitions); 
        
        for r=1:repetitions
            fprintf('Evaluating QPC repetition %d of %d\n',r,repetitions);

            
             tic;
             [w qpc info]=qpctrain(data(i).x,data(i).y,'OptMethod','gd','QPCMethod','qpc','initiations',init,'learningRate',lr,'display','short','directions',directions,'dataname',data(i).name);
             time=toc;
                
             iter=info{1}.iter;
            
            fprintf(f,'Method= QPC\nrepetition=%d\ntime=%f\nQPC=%f\niterations=%d\n\n',r,time,qpc,iter);

            results.qpc(r) = qpc;
            results.time(r) = time;
            results.iter(r) = iter;
        end
        
        results.qpc_avg = mean(results.qpc);
        results.time_avg = mean(results.time); 
        results.iter_avg = mean(results.iter);

        results.qpc_std = std(results.qpc);
        results.time_std = std(results.time); 
        results.iter_std = std(results.iter);
    
        fprintf(f,'---------------------------\n');
        fprintf(f,'Average over %d trials\n',repetitions);
        fprintf(f,'QPC= %f %f\n',results.qpc_avg,results.qpc_std);
        fprintf(f,'time= %f %f\n',results.time_avg,results.time_std);
        fprintf(f,'iter= %f %f\n',results.iter_avg,results.iter_std);
        fprintf(f,'\nSummary dataname/qpc/time/iter:\n%s %.2f %.2f %.2f %.2f %.1f %.1f\n',data(i).name,results.qpc_avg,results.qpc_std,results.time_avg,results.time_std,results.iter_avg,results.iter_std);
        
        fclose(f);

        all_qpc_results{i}=results;
        clear results;

      %  catch
      %  end
end

save(strcat(savedir,'allresuts.mat'),'all_qpc_results','all_qpcproto_results');

function [qpc time biter baqpc]=qpctrain_proto_test(data,init,randominit,lr,plr,intervals)
    
    baqpc = -Inf;
    biter = 0;
    bw = [];
    
    tic;
    for i=1:init
         [w aqpc proto param]=qpctrain_proto(data.x,data.y,'ProtMethod','qpcquick','prototypes',intervals,'initiations',randominit,'plr',plr,'learningRate',lr,'display','short','directions',1,'dataname',data.name);

         if aqpc > baqpc
            baqpc = aqpc;
            disp(param);
            biter = param{1}.iter;
            bw = w;
        end
    end
    time=toc;
    qpc=qpcfunction(data.x,data.y,bw);
    
return

