function runtest_qpc_quick2(inputpath)
% test QPC_quick dla szeregu dancych.
% Wynikiem jest dla kazdego zbioru
%    * wykres bgraph dla kazdego kierunku oraz scatterplot
%    * plik tekstowy z inf. o zb. danych, parametrach modelu  oraz czasie liczenia algorytmu
%    * porownanie z wynikiem dla qpc tradycyjnego

if nargin < 1
%    inputpath='c:\\_users\grochu\work\matlab\qpc\data\';  
    inputpath = '/home/marek/data/test/';
end


data = load_data(inputpath);

%method='qpc_quick';

savedir = strcat(datestr(now,'yy.mm.dd'),'.qpcquick/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

k=20;
b=1;

lr=0.1;
directions=2;

n=size(data,2);
randominit = 1000;

for i=1:n
        x=normalize(data(i).x);
        y=data(i).y;
        
        disp(['dataset: ' data(i).name sprintf('\t%5d',data(i).vectors) ' vectors ' sprintf(' %5d',data(i).features) ' features ' ' loaded']);
        filename=strcat(savedir,sprintf('%s.qpc_quick.k%d',data(i).name,k));
        f=fopen(strcat(filename,'.all.log')','w');
        fprintf(f,'dataset: %s\nvectors: %d\nfeatures: %d\n',data(i).name,data(i).vectors,data(i).features);
        
        fprintf('Evaluating QPC_quick\n');
       
        tic;
        [bw aprqpc]=qpctrain(x,y,'OptMethod','random','QPCMethod','quick','initiations',randominit,'beta',b,'prototypes',k,'learningRate',lr,'display','short','directions',directions,'dataname',data(i).name);
        t1=toc;
        fprintf(f,'Method: QPC_quick\ndirections: %d\nk: %d\ntime: %f\n',directions,k,t1);
 
        qpc1=qpcfunction(x,y,bw);
        % qpc=qpcfunction(x,y,bw);

        str=cell(1,3);
        for d=1:directions
             fprintf(f,' dim=%d aQPC=%6.3f   QPC=%6.3f\n',d,aprqpc(d),qpc1(d));

             str{1}='';
             str{2}=sprintf('aQPC = %0.3f',aprqpc(d));
             str{3}=sprintf('QPC = %0.3f',qpc1(d));
             clf;
             bgraph(x*bw(d,:)',y,'weights',bw(d,:),'str',str,'stralign','right');
             saveplot(sprintf('%s.bgraph.d%d',filename,d));
        end
        clf;
        scaterplot(x*bw',y,'features',1:directions);
        saveplot(sprintf('%s.scatter',filename));                
        fclose(f);
        
        %%%%%%%%%% to samo dla tradycyjnego QPC
        filename=strcat(savedir,sprintf('%s.qpc.gauss.0.1',data(i).name));
        f=fopen(strcat(filename,'.all.log')','w');
        
        fprintf('Evaluating QPC\n');
        init = 10;
        tic;
        [bw bqpc]=qpctrain(x,y,'OptMethod','gd','QPCMethod','qpc','initiations',init,'learningRate',lr,'display','short','directions',directions,'dataname',data(i).name);
        t1=toc;
        fprintf(f,'Method: QPC\ndirections: %d\nk: %d\ntime: %f\n',directions,k,t1);
        str=cell(1,2);
        for d=1:directions
             fprintf(f,' dim=%d QPC=%6.3f\n',d,bqpc(d));

             str{1}='';
             str{2}=sprintf('QPC = %0.3f',bqpc(d));
             clf;
             bgraph(x*bw(d,:)',y,'weights',bw(d,:),'str',str,'stralign','right');
             saveplot(sprintf('%s.bgraph.d%d',filename,d));
        end
        clf;
        scaterplot(x*bw',y,'features',1:directions);
        saveplot(sprintf('%s.scatter',filename));                
        fclose(f);
        
  %  catch
  %  end
end

function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);