function results=multitest(x,y,model,folds,repetitions)
%function [avgacc avgstd avgwneurons stdwneurons avgpneurons stdpneurons accall]=multitest(x,y,model,folds,repetitions)
% MULTITEST(X,Y) perform CV test on given data X with labels Y using given
% MODEL
%
%   note that train data in each fold are normalized before lraning
%
%    MULTITEST(X,Y,MODEL,FOLDS) sets number of crossvalidation FOLDS (default 10)
%    MULTITEST(X,Y,FOLDS,REPETITIONS) sets number of REPEROTIONS of CV test
%    (default 1)
%
%   Posible outputs are:
%   =MULTITEST(X,Y,MODEL)
%   [ACC STD NEURONS NSTD ACCTABLE NTABLE]=MULTITEST(X,Y,MODEL)
%    
%   ACC average accuracy
%   STD average standard deviation of accuracy
%   NEURONS average number of NEURONS
%   NSTD standard deviation of number of neurons
%   ACCTABLE table containing accuracy for eeach test and each CV fold
%   NTABLE   table containing number of neurons obtaining for each test and
%   each fold

% trainmodel - function handle $(x,y)f() that learns model
%    MULTITEST(X,Y,FOLDS,REPETITIONS,MODEL) sets MODEL for testing, MODEL must be
%    a function handle of form @(X,Y)MODEL(X,Y) (default PPINETWORK is used with default parameters)

if nargin < 5 ; repetitions = 1; end
if nargin < 4; folds = 10; end
if nargin < 3; error('Please speciffy a MODEL'); end

traintransform=@(x)normalize(x);
testtransform=@(x,a)normalize(x,a);

results.folds = folds;
results.repetitions = repetitions;

results.accuracy_avg = [];
results.accuracy_std = [];

results.accuracy = zeros(folds,repetitions);
results.hidden = zeros(folds,repetitions);
results.output = zeros(folds,repetitions);

results.hidden_avg = [];
results.hidden_std = [];
results.output_avg = [];
results.output_std = [];

for n=1:repetitions
    indices = crossvalind('Kfold',y,folds);
    for i=1:folds
        fprintf('\n=======  Test %d fold %d ========================\n\n',n,i);
        trainid=(indices~=i);
        % train = x(perm(indexes == 1),:)
        
        [traindata a]=traintransform(x(trainid,:));
        testdata=testtransform(x(~trainid,:),a);
        net = model.train(traindata,y(trainid));
        acc = model.test(testdata,y(~trainid),net);

%          figure(2);
%          clf;
%          bgraph3(traindata*net.qpcw',y(trainid,:),'sigma',0.2);
%          hold on;
%          prefix='data';
%          bgraph3(testdata*net.qpcw',y(~trainid,:),'select','yes');
%          print('-dpng','-r96',sprintf('%s.cv%02d.bgraph.png',prefix,i));
       
%         acc = 80 + randn(1)*3;
%         net.nw = 2 + floor(rand(1)*2)-1;
%         net.np = 3 + floor(rand(1)*4)-2;
        
        results.accuracy(i,n) = acc;
        results.hidden(i,n) = net.nw;
        results.output(i,n) = net.np;
        
 %        if display > 0
          fprintf(' Test acc. %4.1f \n',acc);
   %         fprintf(' Test acc. %4.1f hidden %d prototypes %d\n',acc,net.nw,net.np);
 %       end
        
   end
end

[results.accuracy_avg results.accuracy_std]= stats(results.accuracy);
[results.hidden_avg results.hidden_std] = stats(results.hidden);
[results.output_avg results.output_std] = stats(results.output);

return;


function [omean ostd]=stats(table)
    mean1 = mean(table,1);  
    std1  = std(table,1);
    omean=mean(mean1); 
%    std2=std(mean1);
    ostd=mean(std1); 
    %std3=std(std1);





% fprintf('\n\nHidden Neurons\n');
% [avgwneurons stdwneurons]=printresults(wnodes);
% fprintf('\n\nPrototypes\n');
% [avgpneurons stdpneurons]=printresults(pnodes);
% fprintf('\n\nTest accuracy\n');
% [avgacc avgstd]=printresults(accall);
% return







% vectors=size(x,1);
% fv = floor(vectors/folds);
% rest = vectors - fv*folds;
% 
% accall=zeros(folds,repetitions);
% wnodes = zeros(folds,repetitions);
% pnodes = zeros(folds,repetitions);
% 
% for n=1:repetitions
%     perm = randperm(vectors);
%     
%     ip = 1; 
%     for i=1:folds
%         fprintf('\n=======  Test %d fold %d ========================\n\n',n,i);
% 
%         fvc = fv;
%         if rest > 0
%               fvc = fvc + 1;
%               rest = rest - 1;
%         end
%         indexes = zeros(vectors,1);
%         ik = ip + fvc;
%         indexes(ip:ik-1)=1;
%         
%         % train = x(perm(indexes == 1),:)
%         [train a]=traintransform(x(perm(indexes == 0),:));
%         
%         net = model(train,y(perm(indexes == 0)));
% 
% % odkomentowac dla sieci PPI/QPC (14.03.2009)
% %         for no = 1:size(net,2)
% %             nodes(i,n) = nodes(i,n) + net{no}.n;
% %         end
% 
% 
%         curracc=testmodel(testtransform(x(perm(indexes == 1),:),a),y(perm(indexes == 1)),net);
% 
%         accall(i,n)=curracc;
%         wnodes(i,n)=net.nw;
%         pnodes(i,n)=net.np;
%         ip = ik;
%         
%  %        if display > 0
%             fprintf(' Test acc. %4.1f hidden %d prototypes %d\n',curracc,net.nw,net.np);
%  %       end
%       
%    end
% end
% 
% fprintf('\n\nHidden Neurons\n');
% [avgwneurons stdwneurons]=printresults(wnodes);
% fprintf('\n\nPrototypes\n');
% [avgpneurons stdpneurons]=printresults(pnodes);
% fprintf('\n\nTest accuracy\n');
% [avgacc avgstd]=printresults(accall);
% return
% 
function [mean2 std2]=printresults(table)
    [folds tests]=size(table);
    fprintf('Test : %s \n',sprintf(' %6d',1:tests));
    fprintf('------ \n');
    for i=1:folds
        fprintf('%2d fold %s\n',i,sprintf(' %6.2f',table(i,:)));
    end
    fprintf('------ \n');
    mean1 = mean(table);  
    std1  = std(table);
    mean2=mean(mean1); std2=std(mean1);
    mean3=mean(std1); std3=std(std1);

    fprintf('Avg  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',mean1),mean2,std2);
    fprintf('Std  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',std1),mean3,std3);

    return;
