function [weights uqpc prototypes]=uqpc_train(x,varargin)
% Nienadzorowane uczenie QPC z prototypami.
% Prototypy dokonuja klasteryzacji (nazwa uqpc1) - pomysl wynaga dopracowania.
% Prototypy w poczonej przestrzeni nie oddaj dobrze pozycji klastrw.
% Na razie rozwijam bardziej obiecujaca wersje redukujaca liczbe wymiarow
% (nazwana uqpc2)
%
%
%   W = UQPC_TRAIN(X,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize QPC index value
%	X : dataset (without labels)
%
%   W = UQPC_TRAIN(X,K,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize QPC index value
%	X : dataset (without labels)
%	K : number of clusters (prototypes)
%
%   W = QPCTRAIN_PROTO(DATA,PARAMETERS,VALUE,...)
%   DATA : data structure created by LOAD_DATA function 
%    e.g LOAD_DATA([X Y]).
%   
%   For QPC learning options refer to "help qpc_config".
%
%   Unsupervsed QPC options:
%               'K'  - number of prototypes (default 2);
%               Note: uqpc_train(x,k) == uqpc_train(x,'K',k)
%
%               'uqpc_initiations' - number of random initiations of
%               weights and prototypes (deafault '10). It is only one steap
%               learning (no optimization steps are made), just draw N
%               times and choose the best one (in terms of UQPC function).
%               'QPCMethod'  - stosowana metoda (jest to tak naprawde opcja
%               QPC). 
%               Wartosci: 'uqpc1' - klasteryzacja prototypami (nieskonczone)
%                         'uqpc2' (default) - redukcja wymiarowosci
%
%	e.g.   w=uqpc_train(x,3,'directions',2)
%  is equal to
%	       w=uqpc_train(x,'directions',2,'prototypes',3)

if nargin < 1; error('Give me some data, please.'); end;

% Function uqpc_train_config is below.
[uqpc_parameters unmached] = uqpc_train_config(varargin{:});
qpc_parameters = qpc_config(unmached);

% learning rate for prototypes positions
if qpc_parameters.plr == 0 
    qpc_parameters.plr = qpc_parameters.learningRate;
end

qpc_parameters.QPCMethod = uqpc_parameters.QPCMethod;
is_uqpc1 = strcmp(qpc_parameters.QPCMethod,'uqpc1');
is_uqpc2 = strcmp(qpc_parameters.QPCMethod,'uqpc2');
is_log = strcmp(qpc_parameters.log,'on');
qpc_parameters.log = 'off'; % Wylaczam zapis dla podrzednych fincji. 
is_display = ~strcmp(qpc_parameters.display,'none');

qpc_parameters.prototypes = uqpc_parameters.K;
qpc_parameters.multistart = 'no';

directions = qpc_parameters.directions;
protoCount = uqpc_parameters.K;
[vectorsCount featuresCount ]=size(x);
lab=1:protoCount;
prototypes=[zeros(protoCount,directions) lab'];
weights = zeros(directions,featuresCount);
uqpc = zeros(directions,1);

if directions > featuresCount; directions = featuresCount ; end 

if is_uqpc1
    % Inicjalizacja prototypow robiona tylko raz na poczatku
    [qpc_parameters.prototypes weights]=uqpc1_init(x,protoCount,uqpc_parameters.uqpc_initiations);
    qpc_parameters.initWeights = rand(initiations,featuresCount)-1.0;
    qpc_parameters.initWeights(1,:) = weights;
    
    repetitions = 1; % bez powtrzen uczenia (inicjalizacje robione sa podczas uczenia qpc)
else
    repetitions = uqpc_parameters.uqpc_initiations;
    % inicjalizacje robione sa w tej funkcji i uczenie qpc nie robi juz
    % kolejnych inicjalizacji
end

logfilename = sprintf('%s_uqpc_train_k%d_%s',qpc_parameters.dataName,...
        uqpc_parameters.K,datestr(now,'yymmdd-HHMM'));

qpclearning = @(x,p)qpc_1d(x,[],p);

format compact;
suqpcp = evalc('uqpc_parameters'); 
sqpcp = evalc('qpc_parameters');

if is_log 
    file = fopen(strcat(logfilename,'.log'),'w');
    fprintf(file,'  %s\n  %s\n',suqpcp,sqpcp);
end
if is_display;  fprintf(1,'Parameters:\n%s\n%s\n',suqpcp,sqpcp); end

for dirCount = 1:directions
    
    if dirCount == 1
        P =  [];
        xp = x;
    else
        P=eye(featuresCount)-weights'*weights;  % operator projekcji na podprz. otronormalna
        xp = x*P;
        
        if is_uqpc1; 
            % przenoszenie prototypow do nowej podprzestrzeni - niestety,
            % nie jest to zrobione dobrze - do poprawy
            qpc_parameters.prototypes = [qpc_parameters.prototypes(:,1:end-1)*P qpc_parameters.prototypes(:,end)];    
            qpc_parameters.initWeights = [];
        end
    end
    
    %    uqpc_parameters.logfilename=sprintf('%s.d%d',logfilename,dirCount);

    bqpc = -Inf;
    bw = [];
    
    for init=1:repetitions
        
        if is_uqpc2      % Inicjalizacja uqpc2
            % TODO - sprawdzi poprawnosc inicjalizacji w przypadku braku
            % etykiet - ewentualnie dopisac nowe funkcje
            
           [qpc_parameters.prototypes ...
               qpc_parameters.initWeights ...
               qpc_parameters.beta]=uqpc1_init(x,...
               protoCount,uqpc_parameters.uqpc_initiations);

            % w1=qpctrain(xp,[],'prototypes',qpc_parameters.prototypes,'directions',1,'initiations',qpc_parameters.initiations,'OptMethod','random','QPCMethod','quick','function',qpc_parameters.function,'beta',1);
            % p2=project_points(p1(:,1:end-1),w1,mean(xp));
            % qpc_parameters.prototypes = [p2 p1(:,end)];
            % qpc_parameters.beta = sigma1;
            % qpc_parameters.initWeights;
            qpc_parameters.initiations = 1;        
        end
        
        [w2 qpc2 param2]=qpclearning(xp,qpc_parameters);
        
        if qpc2 > bqpc
            bqpc = qpc2;
            bw = w2;
            bparam = param2;
        end
    
    end
    
    
    px = bparam.prototypes(:,1:end-1)*bw';

    if dirCount > 1
         % pn=pn*P;
         % Nie wiem jak przeskalowac pozycje prototypow
         % tak aby rzut p*w pozosta niezmieniony.
         % Na razie robie to na opak: zapamietuje pozycje prototypow w R^1
         % wzgledem w*x a nastpnie przeskalowuje tak aby pasowao.
         
         % Zapamietuje pozycje prototypow
         m=minmax(bw*xp');
         sc=px-m(1);
         sc=sc./(m(2)-m(1));
         
        bw=bw*P;
        bw=bw/norm(bw);
        
        % Odtwarzam pozycje prototypow wzgl. wx
         m=minmax(bw*x');
         px=m(1)+(m(2)-m(1)).*sc;
    end
    
    prototypes(:,dirCount) = px;
    weights(dirCount,:)=bw; %/norm(bw);
    uqpc(dirCount)=bqpc;
    % info{dirCount} = bparam.info;

    if is_log || strcmp(qpc_parameters.save,'all') || strcmp(qpc_parameters.save,'last')
  % if display > 0
        clf;
        bgraph(x*weights(dirCount,:)',ones(vectorsCount,1));
        hold on;
        bgraph(prototypes(:,dirCount),prototypes(:,end),'select','yes','borders','yes');
        saveplot(sprintf('%s_bgraph_d%d',logfilename,dirCount));
        
        for f=2:dirCount
            clf;
            scaterplot(x*weights(1:dirCount,:)',ones(vectorsCount,1),[f-1 dirCount]);
            if ~is_uqpc2
                scaterplot(prototypes(:,1:end-1),prototypes(:,end),[f-1 dirCount],'select','yes','borders','yes');
            end
            saveplot(sprintf('%s_scatterplot_d%d-%d',logfilename,f-1,dirCount));
        end
    end
end

sw=evalc('weights');
sq=evalc('uqpc');
sp=evalc('prototypes');

if is_log;  fprintf(file,'\n  %s\n  %s\n  %s\n',sw,sq,sp); end
if is_display ; fprintf(1,'%s\n%s\n%s\n',sw,sq,sp); end

if strcmp(qpc_parameters.save,'all') || strcmp(qpc_parameters.save,'last')
%if display > 0
%     w=bestw
%     qpc=bestqpc
%     prototypes=bestp
%     clf;
%     scaterplot(data.x*bestw',data.y,1:directions);
%     scaterplot([pwx{:}],bestproto{1}(:,end),1:directions,'select','yes','borders','yes');
%     saveplot(sprintf('%s.scatterplot.all',logfilename));
end


if is_log ; fclose(file); end

return



function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);
% % octave only
% %	print('-dpng','-S640,480',name);


%    name = strcat(prefix,'.eps');
%  	 print('-depsc',name);



function [parameters unmatched]=uqpc_train_config(varargin)

param = inputParser;
param.KeepUnmatched = true;
% data
param.addOptional('K',2,@isnumeric);
param.addParamValue('uqpc_initiations',10,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('QPCMethod','uqpc2',@(x)any(strcmpi(x,{'uqpc1','uqpc2'})));

param.parse(varargin{:});
parameters = param.Results;
unmatched = param.Unmatched;
unames=fieldnames(unmatched);
clear param;

if nargout  < 2 && size(unames,1) > 0
        error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
end

return;


function [prototypes weights sigma]=uqpc1_init(x,protoCount,initiations)


bqpc = -Inf;
bw = [];
wh=1; % wsp. decydujacy o dyspersji sigma=wh*h

%%% Initition of prototype positions
for init=1:initiations
    %%% Chose best initiation
    %%% 1. Random weight [-1/2,+1/2]
    %%% 2. Split into k intervals
    %%% 3. Set init prototype positions
    %%%     a. In the middle of vectors in each interval
    %%%     b. or pure random init
    
    featuresCount = size(x,2);
    
    w=rand(1,featuresCount)-1;
    xw=x*w';
    yminmax=minmax(xw');
    h = (yminmax(:,2)-yminmax(:,1))./protoCount;
    prototypes = zeros(protoCount,featuresCount+1);
    sigma = wh*h;

    for i=1:protoCount
      ind= xw <= yminmax(:,1)+i*h; 
      prototypes(i,:)=[mean(x(ind,:)) i];
    end

 %   [w2 qpc2 param2]=qpclearning(x,qpc_parameters);
    uqpc=uqpc_function(x,w,prototypes);
    % TODO: dobor funkcji G (szerokosc moze miec wplyw na wynki).

    if uqpc > bqpc
        bqpc = uqpc;
        bproto = prototypes;
        bw = w;
        bsigma = sigma;
    end
end
prototypes = bproto;
weights = bw; % pierwsza inicjalizacja ustalona
sigma = bsigma;
return;


